@extends('layouts.admin')

@section('title', 'System Settings')
@section('header_title', 'System Settings')

@section('content')
@section('content')
<div x-data="{ activeTab: 'remote' }" class="space-y-6">
    
    <!-- Tab Navigation -->
    <div class="bg-white rounded-2xl p-1.5 border border-gray-200 inline-flex shadow-sm">
        <button @click="activeTab = 'remote'" 
            :class="activeTab === 'remote' ? 'bg-primary text-white shadow-md' : 'text-gray-500 hover:text-gray-900'"
            class="px-6 py-2.5 rounded-xl text-sm font-bold transition-all flex items-center gap-2">
            <i class="fa-brands fa-firebase"></i>
            Remote Config
        </button>
        <button @click="activeTab = 'server'" 
            :class="activeTab === 'server' ? 'bg-gray-800 text-white shadow-md' : 'text-gray-500 hover:text-gray-900'"
            class="px-6 py-2.5 rounded-xl text-sm font-bold transition-all flex items-center gap-2">
            <i class="fa-solid fa-server"></i>
            Server Environment
        </button>
    </div>

    <!-- Remote Config Tab -->
    <div x-show="activeTab === 'remote'" x-transition:enter="transition ease-out duration-300" x-transition:enter-start="opacity-0 translate-y-4" x-transition:enter-end="opacity-100 translate-y-0">
        <div class="bg-white rounded-3xl border border-gray-100 shadow-sm p-8">
            <div class="flex items-center gap-4 mb-8">
                <div class="w-12 h-12 rounded-2xl bg-orange-50 text-orange-600 flex items-center justify-center text-2xl font-bold shadow-sm ring-4 ring-orange-50/50">
                    <i class="fa-brands fa-firebase"></i>
                </div>
                <div>
                    <h3 class="font-black text-gray-900 text-xl">Remote Configuration</h3>
                    <p class="text-sm text-gray-400 font-medium">Manage app versions and global variables via Firebase RTDB.</p>
                </div>
            </div>

            <form action="{{ route('admin.settings.update-company') }}" method="POST" class="space-y-10">
                @csrf
                
                <!-- Mobile Apps -->
                <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
                    <!-- Android -->
                    <div class="space-y-5 p-6 bg-gray-50 rounded-3xl border border-gray-100 relative group hover:border-emerald-200 transition-colors">
                        <div class="absolute top-0 right-0 p-4 opacity-5 group-hover:opacity-10 transition-opacity">
                            <i class="fa-brands fa-android text-8xl text-emerald-600"></i>
                        </div>
                        <h4 class="font-bold text-gray-800 flex items-center gap-3 text-lg">
                            <div class="w-8 h-8 rounded-lg bg-emerald-100 text-emerald-600 flex items-center justify-center"><i class="fa-brands fa-android"></i></div>
                            Android Config
                        </h4>
                        <div class="grid grid-cols-2 gap-4 relative z-10">
                            <div>
                                <label class="text-[10px] font-black uppercase text-gray-400 mb-1 block">Latest Version</label>
                                <input type="text" name="android[latest_version]" value="{{ $firebaseData['android']['latest_version'] ?? '' }}" class="input-field" placeholder="1.0.0">
                            </div>
                            <div>
                                <label class="text-[10px] font-black uppercase text-gray-400 mb-1 block">Min Version</label>
                                <input type="text" name="android[min_version]" value="{{ $firebaseData['android']['min_version'] ?? '' }}" class="input-field" placeholder="1.0.0">
                            </div>
                        </div>
                        <div class="relative z-10">
                            <label class="text-[10px] font-black uppercase text-gray-400 mb-1 block">Store URL</label>
                            <input type="url" name="android[store_url]" value="{{ $firebaseData['android']['store_url'] ?? '' }}" class="input-field" placeholder="https://play.google.com/...">
                        </div>
                        <div class="relative z-10">
                            <label class="text-[10px] font-black uppercase text-gray-400 mb-1 block">Update Message</label>
                            <textarea name="android[update_message]" rows="2" class="input-field">{{ $firebaseData['android']['update_message'] ?? '' }}</textarea>
                        </div>
                        <div class="flex items-center gap-3 relative z-10 bg-white p-3 rounded-xl border border-gray-200/50">
                            <div class="relative flex items-center">
                                <input type="hidden" name="android[is_forced]" value="false">
                                <input type="checkbox" name="android[is_forced]" value="true" {{ ($firebaseData['android']['is_forced'] ?? false) ? 'checked' : '' }} class="w-5 h-5 rounded text-emerald-500 focus:ring-emerald-500 border-gray-300">
                            </div>
                            <label class="text-xs font-bold text-gray-700">Force Update Required</label>
                        </div>
                    </div>

                    <!-- iOS -->
                    <div class="space-y-5 p-6 bg-gray-50 rounded-3xl border border-gray-100 relative group hover:border-gray-300 transition-colors">
                        <div class="absolute top-0 right-0 p-4 opacity-5 group-hover:opacity-10 transition-opacity">
                            <i class="fa-brands fa-apple text-8xl text-gray-800"></i>
                        </div>
                        <h4 class="font-bold text-gray-800 flex items-center gap-3 text-lg">
                            <div class="w-8 h-8 rounded-lg bg-gray-200 text-gray-800 flex items-center justify-center"><i class="fa-brands fa-apple"></i></div>
                            iOS Config
                        </h4>
                        <div class="grid grid-cols-2 gap-4 relative z-10">
                            <div>
                                <label class="text-[10px] font-black uppercase text-gray-400 mb-1 block">Latest Version</label>
                                <input type="text" name="ios[latest_version]" value="{{ $firebaseData['ios']['latest_version'] ?? '' }}" class="input-field" placeholder="1.0.0">
                            </div>
                            <div>
                                <label class="text-[10px] font-black uppercase text-gray-400 mb-1 block">Min Version</label>
                                <input type="text" name="ios[min_version]" value="{{ $firebaseData['ios']['min_version'] ?? '' }}" class="input-field" placeholder="1.0.0">
                            </div>
                        </div>
                        <div class="relative z-10">
                            <label class="text-[10px] font-black uppercase text-gray-400 mb-1 block">Store URL</label>
                            <input type="url" name="ios[store_url]" value="{{ $firebaseData['ios']['store_url'] ?? '' }}" class="input-field" placeholder="https://apps.apple.com/...">
                        </div>
                        <div class="relative z-10">
                            <label class="text-[10px] font-black uppercase text-gray-400 mb-1 block">Update Message</label>
                            <textarea name="ios[update_message]" rows="2" class="input-field">{{ $firebaseData['ios']['update_message'] ?? '' }}</textarea>
                        </div>
                        <div class="flex items-center gap-3 relative z-10 bg-white p-3 rounded-xl border border-gray-200/50">
                            <div class="relative flex items-center">
                                <input type="hidden" name="ios[is_forced]" value="false">
                                <input type="checkbox" name="ios[is_forced]" value="true" {{ ($firebaseData['ios']['is_forced'] ?? false) ? 'checked' : '' }} class="w-5 h-5 rounded text-gray-900 focus:ring-gray-900 border-gray-300">
                            </div>
                            <label class="text-xs font-bold text-gray-700">Force Update Required</label>
                        </div>
                    </div>
                </div>

                <!-- Global & Company Info -->
                <div class="space-y-6 pt-8 border-t border-gray-100">
                    <h4 class="font-black text-gray-900 uppercase tracking-tight text-sm flex items-center gap-2">
                        <i class="fa-solid fa-globe text-gray-400"></i> Global Settings
                    </h4>
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                        <div>
                            <label class="label-heading">Contact Email</label>
                            <input type="email" name="globals[email]" value="{{ $firebaseData['globals']['email'] ?? '' }}" class="input-field">
                        </div>
                        <div>
                            <label class="label-heading">WhatsApp</label>
                            <input type="text" name="globals[whatsapp]" value="{{ $firebaseData['globals']['whatsapp'] ?? '' }}" class="input-field">
                        </div>
                        <div>
                            <label class="label-heading">Website URL</label>
                            <input type="url" name="globals[website]" value="{{ $firebaseData['globals']['website'] ?? '' }}" class="input-field">
                        </div>
                        <div>
                            <label class="label-heading">API Base URL</label>
                            <input type="url" name="globals[api_base_url]" value="{{ $firebaseData['globals']['api_base_url'] ?? '' }}" class="input-field">
                        </div>
                        <div>
                            <label class="label-heading">Media URL</label>
                            <input type="url" name="globals[media_url]" value="{{ $firebaseData['globals']['media_url'] ?? '' }}" class="input-field">
                        </div>
                        <div>
                             <label class="label-heading">Chat Link</label>
                            <input type="url" name="globals[chat_link]" value="{{ $firebaseData['globals']['chat_link'] ?? '' }}" class="input-field">
                         </div>
                        <div>
                            <label class="label-heading">Country</label>
                            <input type="text" name="globals[country]" value="{{ $firebaseData['globals']['country'] ?? '' }}" class="input-field">
                        </div>
                        <div>
                            <label class="label-heading">Currency</label>
                            <input type="text" name="globals[currency]" value="{{ $firebaseData['globals']['currency'] ?? '' }}" class="input-field">
                        </div>
                        <div>
                            <label class="label-heading">App Key</label>
                            <input type="text" name="globals[app_key]" value="{{ $firebaseData['globals']['app_key'] ?? '' }}" class="input-field font-mono text-xs">
                        </div>
                    </div>
                </div>

                <!-- Links -->
                 <div class="space-y-6 pt-8 border-t border-gray-100">
                    <h4 class="font-black text-gray-900 uppercase tracking-tight text-sm flex items-center gap-2">
                        <i class="fa-solid fa-link text-gray-400"></i> Important Links
                    </h4>
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                        <div>
                            <label class="label-heading">Privacy Policy</label>
                            <input type="url" name="links[privacy]" value="{{ $firebaseData['links']['privacy'] ?? '' }}" class="input-field">
                        </div>
                        <div>
                            <label class="label-heading">Terms & Conditions</label>
                            <input type="url" name="links[terms]" value="{{ $firebaseData['links']['terms'] ?? '' }}" class="input-field">
                        </div>
                        <div>
                            <label class="label-heading">Safety / FAQ</label>
                            <input type="url" name="links[faq]" value="{{ $firebaseData['links']['faq'] ?? '' }}" class="input-field">
                        </div>
                    </div>
                </div>

                <!-- Maintenance Mode -->
                <div class="bg-red-50 p-6 rounded-3xl border border-red-100 flex items-start gap-6 shadow-sm">
                    <div class="pt-1">
                        <input type="hidden" name="maintenance[is_active]" value="false">
                        <div class="flex items-center h-5">
                           <input type="checkbox" name="maintenance[is_active]" value="true" {{ ($firebaseData['maintenance']['is_active'] ?? false) ? 'checked' : '' }} class="w-6 h-6 rounded-lg text-red-600 focus:ring-red-600 border-red-200 bg-white">
                        </div>
                    </div>
                    <div class="flex-1 space-y-4">
                        <h4 class="font-bold text-red-800 text-lg">Maintenance Mode</h4>
                        <div class="grid grid-cols-1 gap-4">
                             <input type="text" name="maintenance[title]" value="{{ $firebaseData['maintenance']['title'] ?? '' }}" placeholder="Title" class="w-full px-4 py-3 rounded-xl border border-red-200 focus:border-red-500 outline-none font-bold text-red-900 placeholder-red-300">
                             <textarea name="maintenance[message]" rows="2" placeholder="Maintenance message displayed to users..." class="w-full px-4 py-3 rounded-xl border border-red-200 focus:border-red-500 outline-none font-medium text-red-800 placeholder-red-300">{{ $firebaseData['maintenance']['message'] ?? '' }}</textarea>
                        </div>
                    </div>
                </div>

                <div class="flex justify-end pt-4">
                    <button type="submit" class="px-8 py-4 bg-gradient-to-r from-orange-500 to-red-500 text-white font-black rounded-2xl shadow-xl shadow-orange-500/20 hover:shadow-orange-500/30 hover:scale-[1.02] transition-all flex items-center gap-3">
                        <i class="fa-solid fa-cloud-arrow-up"></i>
                        Update Remote Config
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Server Environment Tab -->
    <div x-show="activeTab === 'server'" x-transition:enter="transition ease-out duration-300" x-transition:enter-start="opacity-0 translate-y-4" x-transition:enter-end="opacity-100 translate-y-0" style="display: none;">
        <div class="bg-white rounded-3xl border border-gray-100 shadow-sm p-8">
            <div class="flex items-center gap-4 mb-8">
                <div class="w-12 h-12 rounded-2xl bg-gray-800 text-white flex items-center justify-center text-2xl font-bold shadow-sm ring-4 ring-gray-100">
                    <i class="fa-solid fa-server"></i>
                </div>
                <div>
                    <h3 class="font-black text-gray-900 text-xl">Server Environment</h3>
                    <p class="text-sm text-gray-400 font-medium">Critical configuration variables (.env).</p>
                </div>
            </div>
            
            <form action="{{ route('admin.settings.update') }}" method="POST" class="space-y-10">
                @csrf
                
                <!-- Core System -->
                <div class="space-y-6">
                    <h4 class="font-black text-gray-900 uppercase tracking-tight text-sm border-b border-gray-100 pb-2">Core System</h4>
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                        <div>
                             <label class="label-heading">App Name</label>
                             <input type="text" name="APP_NAME" value="{{ $env['APP_NAME'] }}" class="input-field">
                        </div>
                        <div>
                            <label class="label-heading">App Environment</label>
                            <select name="APP_ENV" class="input-field bg-white">
                                <option value="local" {{ $env['APP_ENV'] == 'local' ? 'selected' : '' }}>Local (Development)</option>
                                <option value="production" {{ $env['APP_ENV'] == 'production' ? 'selected' : '' }}>Production</option>
                            </select>
                        </div>
                        <div>
                            <label class="label-heading">App Debug</label>
                            <select name="APP_DEBUG" class="input-field bg-white">
                                <option value="true" {{ $env['APP_DEBUG'] == true ? 'selected' : '' }}>Enabled</option>
                                <option value="false" {{ $env['APP_DEBUG'] == false ? 'selected' : '' }}>Disabled</option>
                            </select>
                        </div>
                        <div class="md:col-span-2">
                            <label class="label-heading">App URL</label>
                            <input type="url" name="APP_URL" value="{{ $env['APP_URL'] }}" class="input-field font-mono text-xs">
                        </div>
                        <div>
                            <label class="label-heading">Timezone</label>
                            <input type="text" name="APP_TIMEZONE" value="{{ $env['APP_TIMEZONE'] }}" class="input-field">
                        </div>
                    </div>
                </div>

                <!-- Database -->
                <div class="space-y-6">
                    <h4 class="font-black text-gray-900 uppercase tracking-tight text-sm border-b border-gray-100 pb-2">Database Connection</h4>
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                        <div>
                             <label class="label-heading">DB Connection</label>
                             <input type="text" name="DB_CONNECTION" value="{{ $env['DB_CONNECTION'] }}" class="input-field">
                        </div>
                        <div>
                             <label class="label-heading">DB Host</label>
                             <input type="text" name="DB_HOST" value="{{ $env['DB_HOST'] }}" class="input-field">
                        </div>
                        <div>
                             <label class="label-heading">DB Port</label>
                             <input type="text" name="DB_PORT" value="{{ $env['DB_PORT'] }}" class="input-field">
                        </div>
                        <div>
                             <label class="label-heading">DB Database</label>
                             <input type="text" name="DB_DATABASE" value="{{ $env['DB_DATABASE'] }}" class="input-field">
                        </div>
                        <div>
                             <label class="label-heading">DB Username</label>
                             <input type="text" name="DB_USERNAME" value="{{ $env['DB_USERNAME'] }}" class="input-field">
                        </div>
                        <div>
                             <label class="label-heading">DB Password</label>
                             <input type="password" name="DB_PASSWORD" value="{{ $env['DB_PASSWORD'] }}" class="input-field">
                        </div>
                    </div>
                </div>

                <!-- Mail -->
                <div class="space-y-6">
                    <h4 class="font-black text-gray-900 uppercase tracking-tight text-sm border-b border-gray-100 pb-2">Mail Configuration</h4>
                    <div class="grid grid-cols-1 md:grid-cols-4 gap-6">
                        <div>
                            <label class="label-heading">Mailer</label>
                            <input type="text" name="MAIL_MAILER" value="{{ $env['MAIL_MAILER'] }}" class="input-field">
                        </div>
                        <div>
                            <label class="label-heading">Host</label>
                            <input type="text" name="MAIL_HOST" value="{{ $env['MAIL_HOST'] }}" class="input-field">
                        </div>
                        <div>
                            <label class="label-heading">Port</label>
                            <input type="text" name="MAIL_PORT" value="{{ $env['MAIL_PORT'] }}" class="input-field">
                        </div>
                        <div>
                            <label class="label-heading">Encryption</label>
                            <input type="text" name="MAIL_ENCRYPTION" value="{{ $env['MAIL_ENCRYPTION'] }}" class="input-field">
                        </div>
                        <div class="md:col-span-2">
                             <label class="label-heading">Username</label>
                             <input type="text" name="MAIL_USERNAME" value="{{ $env['MAIL_USERNAME'] }}" class="input-field">
                        </div>
                        <div class="md:col-span-2">
                             <label class="label-heading">Password</label>
                             <input type="password" name="MAIL_PASSWORD" value="{{ $env['MAIL_PASSWORD'] }}" class="input-field">
                        </div>
                        <div class="md:col-span-2">
                             <label class="label-heading">From Address</label>
                             <input type="email" name="MAIL_FROM_ADDRESS" value="{{ $env['MAIL_FROM_ADDRESS'] }}" class="input-field">
                        </div>
                        <div class="md:col-span-2">
                             <label class="label-heading">From Name</label>
                             <input type="text" name="MAIL_FROM_NAME" value="{{ $env['MAIL_FROM_NAME'] }}" class="input-field">
                        </div>
                    </div>
                </div>

                <!-- Storage & AWS -->
                <div class="space-y-6">
                    <h4 class="font-black text-gray-900 uppercase tracking-tight text-sm border-b border-gray-100 pb-2">Storage & Filesystem</h4>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                             <label class="label-heading">Filesystem Disk</label>
                             <select name="FILESYSTEM_DISK" class="input-field bg-white">
                                <option value="local" {{ $env['FILESYSTEM_DISK'] == 'local' ? 'selected' : '' }}>Local</option>
                                <option value="public" {{ $env['FILESYSTEM_DISK'] == 'public' ? 'selected' : '' }}>Public</option>
                                <option value="s3" {{ $env['FILESYSTEM_DISK'] == 's3' ? 'selected' : '' }}>Amazon S3</option>
                            </select>
                        </div>
                        <div>
                             <label class="label-heading">AWS Bucket</label>
                             <input type="text" name="AWS_BUCKET" value="{{ $env['AWS_BUCKET'] }}" class="input-field">
                        </div>
                        <div>
                             <label class="label-heading">AWS Access Key</label>
                             <input type="text" name="AWS_ACCESS_KEY_ID" value="{{ $env['AWS_ACCESS_KEY_ID'] }}" class="input-field font-mono text-xs">
                        </div>
                        <div>
                             <label class="label-heading">AWS Secret Key</label>
                             <input type="password" name="AWS_SECRET_ACCESS_KEY" value="{{ $env['AWS_SECRET_ACCESS_KEY'] }}" class="input-field font-mono text-xs">
                        </div>
                        <div>
                             <label class="label-heading">AWS Region</label>
                             <input type="text" name="AWS_DEFAULT_REGION" value="{{ $env['AWS_DEFAULT_REGION'] }}" class="input-field">
                        </div>
                    </div>
                </div>

                <!-- System Services -->
                <div class="space-y-6">
                    <h4 class="font-black text-gray-900 uppercase tracking-tight text-sm border-b border-gray-100 pb-2">System Services</h4>
                    <div class="grid grid-cols-1 md:grid-cols-4 gap-6">
                        <div>
                             <label class="label-heading">Queue Connection</label>
                             <input type="text" name="QUEUE_CONNECTION" value="{{ $env['QUEUE_CONNECTION'] }}" class="input-field">
                        </div>
                        <div>
                             <label class="label-heading">Cache Store</label>
                             <input type="text" name="CACHE_STORE" value="{{ $env['CACHE_STORE'] }}" class="input-field">
                        </div>
                        <div>
                             <label class="label-heading">Session Driver</label>
                             <input type="text" name="SESSION_DRIVER" value="{{ $env['SESSION_DRIVER'] }}" class="input-field">
                        </div>
                        <div>
                             <label class="label-heading">Session Lifetime</label>
                             <input type="number" name="SESSION_LIFETIME" value="{{ $env['SESSION_LIFETIME'] }}" class="input-field">
                        </div>
                    </div>
                </div>

                <!-- Third Party Integrations -->
                <div class="space-y-6">
                    <h4 class="font-black text-gray-900 uppercase tracking-tight text-sm border-b border-gray-100 pb-2">Integrations & APIs</h4>
                    
                    <!-- EgoSMS -->
                    <div class="bg-gray-50 rounded-2xl p-5 border border-gray-100">
                        <div class="flex items-center gap-2 mb-4">
                            <i class="fa-solid fa-comment-sms text-gray-400"></i>
                            <h5 class="font-bold text-gray-700 text-sm">SMS Gateway (EgoSMS)</h5>
                        </div>
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                            <div>
                                <label class="label-heading">Username</label>
                                <input type="text" name="EGOSMS_USERNAME" value="{{ $env['EGOSMS_USERNAME'] }}" class="input-field">
                            </div>
                            <div>
                                <label class="label-heading">Password</label>
                                <input type="password" name="EGOSMS_PASSWORD" value="{{ $env['EGOSMS_PASSWORD'] }}" class="input-field">
                            </div>
                            <div>
                                <label class="label-heading">Sender ID</label>
                                <input type="text" name="EGOSMS_SENDER" value="{{ $env['EGOSMS_SENDER'] }}" class="input-field">
                            </div>
                        </div>
                    </div>

                    <!-- WhatsApp -->
                    <div class="bg-gray-50 rounded-2xl p-5 border border-gray-100">
                        <div class="flex items-center gap-2 mb-4">
                            <i class="fa-brands fa-whatsapp text-emerald-500"></i>
                            <h5 class="font-bold text-gray-700 text-sm">WhatsApp Business API</h5>
                        </div>
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label class="label-heading">Phone Number ID</label>
                                <input type="text" name="WHATSAPP_PHONE_NUMBER_ID" value="{{ $env['WHATSAPP_PHONE_NUMBER_ID'] }}" class="input-field">
                            </div>
                            <div>
                                <label class="label-heading">Access Token</label>
                                <input type="password" name="WHATSAPP_ACCESS_TOKEN" value="{{ $env['WHATSAPP_ACCESS_TOKEN'] }}" class="input-field font-mono text-xs">
                            </div>
                        </div>
                    </div>

                    <!-- AI Services -->
                    <div class="bg-gray-50 rounded-2xl p-5 border border-gray-100">
                        <div class="flex items-center gap-2 mb-4">
                            <i class="fa-solid fa-brain text-purple-500"></i>
                            <h5 class="font-bold text-gray-700 text-sm">AI & Computer Vision</h5>
                        </div>
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                            <div>
                                <label class="label-heading">OpenAI Key</label>
                                <input type="password" name="OPENAI_API_KEY" value="{{ $env['OPENAI_API_KEY'] }}" class="input-field font-mono text-xs">
                            </div>
                            <div>
                                <label class="label-heading">OpenAI Model</label>
                                <input type="text" name="OPENAI_MODEL" value="{{ $env['OPENAI_MODEL'] }}" class="input-field">
                            </div>
                            <div>
                                <label class="label-heading">Google Vision Key</label>
                                <input type="password" name="GOOGLE_VISION_API_KEY" value="{{ $env['GOOGLE_VISION_API_KEY'] }}" class="input-field font-mono text-xs">
                            </div>
                        </div>
                    </div>
                </div>
                
                 <div class="pt-8 border-t border-gray-100 flex justify-end">
                    <button type="submit" class="px-8 py-4 bg-gray-900 text-white font-black rounded-2xl shadow-xl shadow-gray-900/20 hover:bg-black hover:scale-[1.02] transition-all flex items-center gap-3">
                        <i class="fa-solid fa-save"></i>
                        Save Server Environment
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

@push('styles')
<style>
    .label-heading { display: block; font-size: 10px; font-weight: 900; text-transform: uppercase; color: #9ca3af; margin-bottom: 4px; }
    .input-field { width: 100%; padding: 10px 16px; border-radius: 12px; border: 1px solid #e5e7eb; font-weight: 700; color: #374151; outline: none; transition: all 0.2s; }
    .input-field:focus { border-color: #f97316; box-shadow: 0 0 0 4px rgba(249, 115, 22, 0.1); }
</style>
@endpush
@endsection
tion (Firebase) -->
    <div class="bg-white rounded-3xl border border-gray-100 shadow-sm p-8">
        <div class="flex items-center gap-3 mb-6">
            <div class="w-10 h-10 rounded-xl bg-orange-50 text-orange-600 flex items-center justify-center text-xl font-bold">
                <i class="fa-brands fa-firebase"></i>
            </div>
            <div>
                <h3 class="font-black text-gray-900 text-lg">Remote Configuration</h3>
                <p class="text-sm text-gray-400">Manage app versions, global variables, and maintenance mode via Firebase.</p>
            </div>
        </div>

        <form action="{{ route('admin.settings.update-company') }}" method="POST" class="space-y-8">
            @csrf
            
            <!-- Mobile Apps -->
            <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                <div class="space-y-4 p-5 bg-gray-50 rounded-2xl border border-gray-100">
                    <h4 class="font-bold text-gray-800 flex items-center gap-2">
                        <i class="fa-brands fa-android text-emerald-500"></i> Android Config
                    </h4>
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label class="text-[10px] font-black uppercase text-gray-400">Latest Version</label>
                            <input type="text" name="android[latest_version]" value="{{ $firebaseData['android']['latest_version'] ?? '' }}" class="w-full px-3 py-2 rounded-lg border border-gray-200 text-sm font-bold">
                        </div>
                        <div>
                            <label class="text-[10px] font-black uppercase text-gray-400">Min Version</label>
                            <input type="text" name="android[min_version]" value="{{ $firebaseData['android']['min_version'] ?? '' }}" class="w-full px-3 py-2 rounded-lg border border-gray-200 text-sm font-bold">
                        </div>
                    </div>
                    <div>
                        <label class="text-[10px] font-black uppercase text-gray-400">Store URL</label>
                        <input type="url" name="android[store_url]" value="{{ $firebaseData['android']['store_url'] ?? '' }}" class="w-full px-3 py-2 rounded-lg border border-gray-200 text-sm font-bold">
                    </div>
                    <div>
                        <label class="text-[10px] font-black uppercase text-gray-400">Update Message</label>
                        <textarea name="android[update_message]" rows="2" class="w-full px-3 py-2 rounded-lg border border-gray-200 text-sm font-bold">{{ $firebaseData['android']['update_message'] ?? '' }}</textarea>
                    </div>
                    <div class="flex items-center gap-2">
                        <input type="hidden" name="android[is_forced]" value="false">
                        <input type="checkbox" name="android[is_forced]" value="true" {{ ($firebaseData['android']['is_forced'] ?? false) ? 'checked' : '' }} class="rounded text-primary focus:ring-primary">
                        <label class="text-xs font-bold text-gray-600">Force Update</label>
                    </div>
                </div>

                <div class="space-y-4 p-5 bg-gray-50 rounded-2xl border border-gray-100">
                    <h4 class="font-bold text-gray-800 flex items-center gap-2">
                        <i class="fa-brands fa-apple text-gray-800"></i> iOS Config
                    </h4>
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label class="text-[10px] font-black uppercase text-gray-400">Latest Version</label>
                            <input type="text" name="ios[latest_version]" value="{{ $firebaseData['ios']['latest_version'] ?? '' }}" class="w-full px-3 py-2 rounded-lg border border-gray-200 text-sm font-bold">
                        </div>
                        <div>
                            <label class="text-[10px] font-black uppercase text-gray-400">Min Version</label>
                            <input type="text" name="ios[min_version]" value="{{ $firebaseData['ios']['min_version'] ?? '' }}" class="w-full px-3 py-2 rounded-lg border border-gray-200 text-sm font-bold">
                        </div>
                    </div>
                    <div>
                        <label class="text-[10px] font-black uppercase text-gray-400">Store URL</label>
                        <input type="url" name="ios[store_url]" value="{{ $firebaseData['ios']['store_url'] ?? '' }}" class="w-full px-3 py-2 rounded-lg border border-gray-200 text-sm font-bold">
                    </div>
                    <div>
                        <label class="text-[10px] font-black uppercase text-gray-400">Update Message</label>
                        <textarea name="ios[update_message]" rows="2" class="w-full px-3 py-2 rounded-lg border border-gray-200 text-sm font-bold">{{ $firebaseData['ios']['update_message'] ?? '' }}</textarea>
                    </div>
                    <div class="flex items-center gap-2">
                        <input type="hidden" name="ios[is_forced]" value="false">
                        <input type="checkbox" name="ios[is_forced]" value="true" {{ ($firebaseData['ios']['is_forced'] ?? false) ? 'checked' : '' }} class="rounded text-primary focus:ring-primary">
                        <label class="text-xs font-bold text-gray-600">Force Update</label>
                    </div>
                </div>
            </div>

            <!-- Global & Company Info -->
            <div class="space-y-6 pt-6 border-t border-gray-50">
                <h4 class="font-bold text-gray-800">Global Settings</h4>
                <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                    <div>
                        <label class="text-[10px] font-black uppercase text-gray-400">Contact Email</label>
                        <input type="email" name="globals[email]" value="{{ $firebaseData['globals']['email'] ?? '' }}" class="w-full px-3 py-2 rounded-lg border border-gray-200 text-sm font-bold">
                    </div>
                    <div>
                        <label class="text-[10px] font-black uppercase text-gray-400">WhatsApp</label>
                        <input type="text" name="globals[whatsapp]" value="{{ $firebaseData['globals']['whatsapp'] ?? '' }}" class="w-full px-3 py-2 rounded-lg border border-gray-200 text-sm font-bold">
                    </div>
                    <div>
                        <label class="text-[10px] font-black uppercase text-gray-400">Website URL</label>
                        <input type="url" name="globals[website]" value="{{ $firebaseData['globals']['website'] ?? '' }}" class="w-full px-3 py-2 rounded-lg border border-gray-200 text-sm font-bold">
                    </div>
                    <div>
                        <label class="text-[10px] font-black uppercase text-gray-400">API Base URL</label>
                        <input type="url" name="globals[api_base_url]" value="{{ $firebaseData['globals']['api_base_url'] ?? '' }}" class="w-full px-3 py-2 rounded-lg border border-gray-200 text-sm font-bold">
                    </div>
                    <div>
                        <label class="text-[10px] font-black uppercase text-gray-400">Media URL</label>
                        <input type="url" name="globals[media_url]" value="{{ $firebaseData['globals']['media_url'] ?? '' }}" class="w-full px-3 py-2 rounded-lg border border-gray-200 text-sm font-bold">
                    </div>
                    <div>
                         <label class="text-[10px] font-black uppercase text-gray-400">Chat Link</label>
                        <input type="url" name="globals[chat_link]" value="{{ $firebaseData['globals']['chat_link'] ?? '' }}" class="w-full px-3 py-2 rounded-lg border border-gray-200 text-sm font-bold">
                     </div>
                    <div>
                        <label class="text-[10px] font-black uppercase text-gray-400">Country</label>
                        <input type="text" name="globals[country]" value="{{ $firebaseData['globals']['country'] ?? '' }}" class="w-full px-3 py-2 rounded-lg border border-gray-200 text-sm font-bold">
                    </div>
                    <div>
                        <label class="text-[10px] font-black uppercase text-gray-400">Currency</label>
                        <input type="text" name="globals[currency]" value="{{ $firebaseData['globals']['currency'] ?? '' }}" class="w-full px-3 py-2 rounded-lg border border-gray-200 text-sm font-bold">
                    </div>
                    <div>
                        <label class="text-[10px] font-black uppercase text-gray-400">App Key</label>
                        <input type="text" name="globals[app_key]" value="{{ $firebaseData['globals']['app_key'] ?? '' }}" class="w-full px-3 py-2 rounded-lg border border-gray-200 text-sm font-bold">
                    </div>
                </div>
            </div>

            <!-- Links -->
             <div class="space-y-6 pt-6 border-t border-gray-50">
                <h4 class="font-bold text-gray-800">Important Links</h4>
                <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                    <div>
                        <label class="text-[10px] font-black uppercase text-gray-400">Privacy Policy</label>
                        <input type="url" name="links[privacy]" value="{{ $firebaseData['links']['privacy'] ?? '' }}" class="w-full px-3 py-2 rounded-lg border border-gray-200 text-sm font-bold">
                    </div>
                    <div>
                        <label class="text-[10px] font-black uppercase text-gray-400">Terms & Conditions</label>
                        <input type="url" name="links[terms]" value="{{ $firebaseData['links']['terms'] ?? '' }}" class="w-full px-3 py-2 rounded-lg border border-gray-200 text-sm font-bold">
                    </div>
                    <div>
                        <label class="text-[10px] font-black uppercase text-gray-400">Safety / FAQ</label>
                        <input type="url" name="links[faq]" value="{{ $firebaseData['links']['faq'] ?? '' }}" class="w-full px-3 py-2 rounded-lg border border-gray-200 text-sm font-bold">
                    </div>
                </div>
            </div>

            <!-- Maintenance Mode -->
            <div class="bg-red-50 p-6 rounded-2xl border border-red-100 flex items-start gap-6">
                <div class="pt-1">
                    <input type="hidden" name="maintenance[is_active]" value="false">
                    <div class="flex items-center h-5">
                       <input type="checkbox" name="maintenance[is_active]" value="true" {{ ($firebaseData['maintenance']['is_active'] ?? false) ? 'checked' : '' }} class="w-5 h-5 rounded text-red-600 focus:ring-red-600 border-gray-300">
                    </div>
                </div>
                <div class="flex-1 space-y-4">
                    <h4 class="font-bold text-red-800">Maintenance Mode</h4>
                    <input type="text" name="maintenance[title]" value="{{ $firebaseData['maintenance']['title'] ?? '' }}" placeholder="Title" class="w-full px-3 py-2 rounded-lg border border-red-200 focus:border-red-500 outline-none text-sm">
                    <textarea name="maintenance[message]" rows="2" placeholder="Maintenance message displayed to users..." class="w-full px-3 py-2 rounded-lg border border-red-200 focus:border-red-500 outline-none text-sm">{{ $firebaseData['maintenance']['message'] ?? '' }}</textarea>
                </div>
            </div>

            <div class="flex justify-end pt-4">
                <button type="submit" class="px-8 py-3 bg-orange-500 text-white font-black rounded-xl shadow-lg shadow-orange-500/20 hover:bg-orange-600 transition-all flex items-center gap-2">
                    <i class="fa-solid fa-cloud-arrow-up"></i>
                    Update Remote Config
                </button>
            </div>
        </form>
    </div>

    <!-- Environment Settings (.env) -->
    <div class="bg-white rounded-3xl border border-gray-100 shadow-sm p-8">
        <div class="flex items-center gap-3 mb-6">
            <div class="w-10 h-10 rounded-xl bg-gray-50 text-gray-600 flex items-center justify-center text-xl font-bold">
                <i class="fa-solid fa-server"></i>
            </div>
            <div>
                 <h3 class="font-black text-gray-900 text-lg">Server Environment</h3>
                 <p class="text-sm text-gray-400">Core server configuration variables (.env).</p>
            </div>
        </div>
        
        <form action="{{ route('admin.settings.update') }}" method="POST" class="space-y-8">
            @csrf
            <!-- Use keys from controller variable $env to display values -->
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                     <label class="block text-[10px] font-black uppercase text-gray-400 mb-1">App Name</label>
                     <input type="text" name="APP_NAME" value="{{ $env['APP_NAME'] }}" class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:border-primary outline-none font-bold text-gray-700">
                </div>
                 <div>
                    <label class="block text-[10px] font-black uppercase text-gray-400 mb-1">App Environment</label>
                    <select name="APP_ENV" class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:border-primary outline-none font-bold text-gray-700 bg-white">
                        <option value="local" {{ $env['APP_ENV'] == 'local' ? 'selected' : '' }}>Local (Development)</option>
                        <option value="production" {{ $env['APP_ENV'] == 'production' ? 'selected' : '' }}>Production</option>
                    </select>
                </div>
                <div>
                    <label class="block text-[10px] font-black uppercase text-gray-400 mb-1">App Debug Mode</label>
                    <select name="APP_DEBUG" class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:border-primary outline-none font-bold text-gray-700 bg-white">
                        <option value="true" {{ $env['APP_DEBUG'] == true ? 'selected' : '' }}>Enabled (True)</option>
                        <option value="false" {{ $env['APP_DEBUG'] == false ? 'selected' : '' }}>Disabled (False)</option>
                    </select>
                </div>
                <div>
                    <label class="block text-[10px] font-black uppercase text-gray-400 mb-1">App URL</label>
                    <input type="url" name="APP_URL" value="{{ $env['APP_URL'] }}" class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:border-primary outline-none font-bold text-gray-700">
                </div>
            </div>
            
             <div class="pt-8 border-t border-gray-50 flex justify-end">
                <button type="submit" class="px-8 py-3 bg-gray-800 text-white font-black rounded-xl shadow-lg shadow-gray-800/20 hover:bg-gray-900 transition-all flex items-center gap-2">
                    <i class="fa-solid fa-save"></i>
                    Save .env Changes
                </button>
            </div>
        </form>
    </div>
</div>
@endsection
