@extends('layouts.admin')

@section('title', 'My Profile')
@section('header_title', 'My Profile')

@section('content')
<div class="max-w-4xl mx-auto space-y-6">
    <div class="bg-white rounded-3xl border border-gray-100 shadow-sm overflow-hidden">
        <div class="p-8 border-b border-gray-100 bg-gray-50/50 flex items-center gap-6">
            <div class="w-20 h-20 rounded-2xl bg-primary text-white flex items-center justify-center text-3xl font-black shadow-lg shadow-primary/20">
                {{ substr(Auth::user()->full_name, 0, 1) }}
            </div>
            <div>
                <h2 class="text-2xl font-black text-gray-900">{{ Auth::user()->full_name }}</h2>
                <p class="text-gray-500 font-medium">{{ Auth::user()->email }}</p>
                <div class="mt-2 inline-flex items-center px-2.5 py-0.5 rounded-md text-xs font-bold bg-emerald-100 text-emerald-700 uppercase tracking-wide">
                    {{ Auth::user()->role }} Account
                </div>
            </div>
        </div>

        <form action="{{ route('admin.profile.update') }}" method="POST" class="p-8 space-y-8">
            @csrf
            
            <!-- Personal Information -->
            <div class="space-y-6">
                <h3 class="font-black text-gray-900 text-lg border-b border-gray-100 pb-2">Personal Information</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label class="block text-[10px] font-black uppercase text-gray-400 mb-1">Full Name</label>
                        <input type="text" name="full_name" value="{{ old('full_name', Auth::user()->full_name) }}" class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:border-primary outline-none font-bold text-gray-700 transition-all focus:ring-4 focus:ring-primary/5">
                        @error('full_name') <p class="text-red-500 text-xs font-bold mt-1">{{ $message }}</p> @enderror
                    </div>
                    <div>
                        <label class="block text-[10px] font-black uppercase text-gray-400 mb-1">Email Address</label>
                        <input type="email" name="email" value="{{ old('email', Auth::user()->email) }}" class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:border-primary outline-none font-bold text-gray-700 transition-all focus:ring-4 focus:ring-primary/5">
                        @error('email') <p class="text-red-500 text-xs font-bold mt-1">{{ $message }}</p> @enderror
                    </div>
                </div>
            </div>

            <!-- Security -->
            <div class="space-y-6 pt-6">
                <h3 class="font-black text-gray-900 text-lg border-b border-gray-100 pb-2 flex items-center gap-2">
                    Security 
                    <span class="text-xs font-normal text-gray-400 bg-gray-100 px-2 py-0.5 rounded-md">Leave blank to keep current password</span>
                </h3>
                
                <div class="grid grid-cols-1 gap-6">
                    <div>
                        <label class="block text-[10px] font-black uppercase text-gray-400 mb-1">Current Password</label>
                        <input type="password" name="current_password" class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:border-primary outline-none font-bold text-gray-700 transition-all focus:ring-4 focus:ring-primary/5">
                        @error('current_password') <p class="text-red-500 text-xs font-bold mt-1">{{ $message }}</p> @enderror
                    </div>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label class="block text-[10px] font-black uppercase text-gray-400 mb-1">New Password</label>
                            <input type="password" name="password" class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:border-primary outline-none font-bold text-gray-700 transition-all focus:ring-4 focus:ring-primary/5">
                            @error('password') <p class="text-red-500 text-xs font-bold mt-1">{{ $message }}</p> @enderror
                        </div>
                        <div>
                            <label class="block text-[10px] font-black uppercase text-gray-400 mb-1">Confirm New Password</label>
                            <input type="password" name="password_confirmation" class="w-full px-4 py-3 rounded-xl border border-gray-200 focus:border-primary outline-none font-bold text-gray-700 transition-all focus:ring-4 focus:ring-primary/5">
                        </div>
                    </div>
                </div>
            </div>

            <div class="pt-6 flex justify-end">
                <button type="submit" class="px-8 py-3 bg-gray-900 text-white font-black rounded-xl shadow-lg shadow-gray-900/20 hover:bg-black hover:scale-[1.02] transition-all flex items-center gap-2">
                    <i class="fa-solid fa-save"></i>
                    Save Changes
                </button>
            </div>
        </form>
    </div>
</div>
@endsection
