@extends('layouts.admin')

@section('title', 'Dashboard')
@section('header_title', 'System Overview')

@section('content')
<div class="space-y-8">
    <!-- Stats Grid -->
    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6">
        <!-- Users -->
        <div class="bg-white p-6 rounded-3xl border border-gray-100 shadow-sm">
            <div class="flex items-center justify-between mb-4">
                <div class="w-12 h-12 rounded-2xl bg-blue-50 text-blue-500 flex items-center justify-center">
                    <i class="fa-solid fa-users text-xl"></i>
                </div>
                <span class="text-[10px] font-black uppercase text-gray-400">Total Users</span>
            </div>
            <div class="text-2xl font-black text-gray-800">{{ number_format($stats['total_users']) }}</div>
            <div class="mt-2 text-xs font-medium text-emerald-500 flex items-center gap-1">
                <i class="fa-solid fa-circle text-[6px]"></i>
                {{ number_format($stats['active_users']) }} active users
            </div>
        </div>

        <!-- Businesses -->
        <a href="{{ route('admin.businesses.index') }}" class="bg-white p-6 rounded-3xl border border-gray-100 shadow-sm hover:shadow-md transition-all">
            <div class="flex items-center justify-between mb-4">
                <div class="w-12 h-12 rounded-2xl bg-emerald-50 text-emerald-500 flex items-center justify-center">
                    <i class="fa-solid fa-store text-xl"></i>
                </div>
                <span class="text-[10px] font-black uppercase text-gray-400">Businesses</span>
            </div>
            <div class="text-2xl font-black text-gray-800">{{ number_format($stats['total_businesses']) }}</div>
            <div class="mt-2 text-xs font-medium text-primary flex items-center gap-1">
                <i class="fa-solid fa-shield-check"></i>
                {{ number_format($stats['verified_businesses']) }} verified
            </div>
        </a>

        <!-- Verifications -->
        <div class="bg-white p-6 rounded-3xl border border-gray-100 shadow-sm relative overflow-hidden group">
            <div class="flex items-center justify-between mb-4">
                <div class="w-12 h-12 rounded-2xl bg-vibrant-orange/10 text-vibrant-orange flex items-center justify-center">
                    <i class="fa-solid fa-user-check text-xl"></i>
                </div>
                <span class="text-[10px] font-black uppercase text-gray-400">Pending Verify</span>
            </div>
            <div class="text-2xl font-black text-gray-800">{{ number_format($stats['pending_verifications']) }}</div>
            <div class="mt-2">
                <a href="{{ route('admin.businesses.verifications') }}" class="text-xs font-bold text-vibrant-orange hover:underline">View review queue →</a>
            </div>
            @if($stats['pending_verifications'] > 0)
                <div class="absolute -right-2 -bottom-2 w-16 h-16 bg-vibrant-orange/5 rounded-full group-hover:scale-150 transition-transform"></div>
            @endif
        </div>

        <!-- Listings -->
        <div class="bg-white p-6 rounded-3xl border border-gray-100 shadow-sm">
            <div class="flex items-center justify-between mb-4">
                <div class="w-12 h-12 rounded-2xl bg-purple-50 text-purple-500 flex items-center justify-center">
                    <i class="fa-solid fa-tags text-xl"></i>
                </div>
                <span class="text-[10px] font-black uppercase text-gray-400">Total Listings</span>
            </div>
            <div class="text-2xl font-black text-gray-800">{{ number_format($stats['total_listings']) }}</div>
            <div class="mt-2 text-xs font-medium text-gray-500 flex items-center gap-3">
                <span class="text-emerald-500 font-bold">{{ number_format($stats['active_listings']) }} Live</span>
                <span class="text-vibrant-orange font-bold">{{ number_format($stats['review_listings']) }} In Review</span>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
        <!-- Recent Users -->
        <div class="bg-white rounded-3xl border border-gray-100 shadow-sm overflow-hidden text-sm">
            <div class="px-6 py-5 border-b border-gray-50 flex items-center justify-between">
                <h3 class="font-bold text-gray-800">New Users</h3>
                <a href="#" class="text-xs font-bold text-primary hover:underline">View All</a>
            </div>
            <div class="divide-y divide-gray-50">
                @foreach($recentUsers as $user)
                    <div class="px-6 py-4 flex items-center justify-between hover:bg-gray-50 transition-colors">
                        <div class="flex items-center gap-3">
                            <div class="w-10 h-10 rounded-xl bg-gray-100 flex items-center justify-center text-gray-400 font-bold overflow-hidden">
                                @if($user->profile_photo)
                                    <img src="{{ $user->profile_photo_url }}" class="w-full h-full object-cover">
                                @else
                                    {{ substr($user->full_name, 0, 1) }}
                                @endif
                            </div>
                            <div>
                                <div class="font-bold text-gray-800">{{ $user->full_name }}</div>
                                <div class="text-[10px] text-gray-400 font-medium">{{ $user->email }}</div>
                            </div>
                        </div>
                        <div class="text-right">
                            <div class="text-[10px] font-black uppercase px-2 py-0.5 rounded bg-gray-100 text-gray-500">{{ $user->role }}</div>
                            <div class="text-[10px] text-gray-400 mt-1">{{ $user->created_at->diffForHumans() }}</div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>

        <!-- Recent Listings -->
        <div class="bg-white rounded-3xl border border-gray-100 shadow-sm overflow-hidden text-sm">
            <div class="px-6 py-5 border-b border-gray-50 flex items-center justify-between">
                <h3 class="font-bold text-gray-800">Recent Ads</h3>
                <a href="{{ route('admin.listings.index') }}" class="text-xs font-bold text-primary hover:underline">View All & Manage</a>
            </div>
            <div class="divide-y divide-gray-50">
                @foreach($recentListings as $listing)
                    <div class="px-6 py-4 flex items-center justify-between hover:bg-gray-50 transition-colors">
                        <div class="flex items-center gap-3">
                            <div class="w-10 h-10 rounded-xl bg-gray-100 flex items-center justify-center overflow-hidden border border-gray-100">
                                @if($listing->thumbnail_url)
                                    <img src="{{ $listing->thumbnail_url }}" class="w-full h-full object-cover">
                                @else
                                    <i class="fa-solid fa-image text-gray-300"></i>
                                @endif
                            </div>
                            <div class="max-w-[180px]">
                                <div class="font-bold text-gray-800 truncate">{{ $listing->title }}</div>
                                <div class="text-[10px] text-primary font-bold">{{ $listing->business->name ?? 'Personal' }}</div>
                            </div>
                        </div>
                        <div class="text-right">
                            <div class="text-[10px] font-black uppercase px-2 py-0.5 rounded {{ $listing->status === 'published' ? 'bg-emerald-50 text-emerald-600' : 'bg-orange-50 text-orange-600' }}">
                                {{ $listing->status }}
                            </div>
                            <div class="text-xs font-bold text-gray-800 mt-1">UGX {{ number_format($listing->price_amount) }}</div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>

    <!-- Pending Listings -->
    @if($pendingListings->isNotEmpty())
        <div class="bg-white rounded-3xl border border-gray-100 shadow-sm overflow-hidden">
            <div class="px-6 py-5 border-b border-gray-50 flex items-center justify-between">
                <h3 class="font-bold text-gray-800 text-vibrant-orange flex items-center gap-2">
                    <i class="fa-solid fa-clock-rotate-left"></i>
                    Pending Ads Approval
                </h3>
                <a href="{{ route('admin.listings.index', ['status' => 'review']) }}" class="text-xs font-bold text-gray-500 hover:text-gray-900">View All Pending</a>
            </div>
            <div class="divide-y divide-gray-50">
                @foreach($pendingListings as $listing)
                    <div class="px-6 py-4 flex items-center justify-between hover:bg-gray-50 transition-colors">
                        <div class="flex items-center gap-4">
                            <div class="w-12 h-12 rounded-xl bg-gray-100 flex items-center justify-center overflow-hidden border border-gray-100 relative">
                                @if($listing->thumbnail_url)
                                    <img src="{{ $listing->thumbnail_url }}" class="w-full h-full object-cover">
                                @else
                                    <i class="fa-solid fa-image text-gray-300"></i>
                                @endif
                                <div class="absolute inset-0 bg-vibrant-orange/10 flex items-center justify-center">
                                    <i class="fa-solid fa-hourglass-start text-vibrant-orange drop-shadow-sm"></i>
                                </div>
                            </div>
                            <div>
                                <div class="font-bold text-gray-800">{{ $listing->title }}</div>
                                <div class="text-xs text-gray-500">
                                    Posted by <span class="font-bold text-gray-700">{{ $listing->createdBy->full_name }}</span>
                                    • {{ $listing->created_at->diffForHumans() }}
                                </div>
                            </div>
                        </div>
                        <div class="flex items-center gap-3">
                            <a href="{{ route('admin.listings.show', $listing) }}" class="px-4 py-2 bg-gray-900 text-white text-xs font-bold rounded-xl hover:bg-black transition-all">
                                Review Ad
                            </a>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    @endif

    <!-- Pending Verifications -->
    @if($pendingBusinesses->isNotEmpty())
        <div class="bg-white rounded-3xl border border-gray-100 shadow-sm overflow-hidden">
            <div class="px-6 py-5 border-b border-gray-50">
                <h3 class="font-bold text-gray-800">Business Verification Requests</h3>
            </div>
            <div class="overflow-x-auto">
                <table class="w-full text-left text-sm">
                    <thead class="bg-gray-50 text-[10px] font-black uppercase text-gray-400">
                        <tr>
                            <th class="px-6 py-4">Business Name</th>
                            <th class="px-6 py-4">Owner</th>
                            <th class="px-6 py-4">Requested</th>
                            <th class="px-6 py-4 text-right">Action</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-50">
                        @foreach($pendingBusinesses as $business)
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-6 py-4">
                                    <div class="flex items-center gap-3">
                                        <div class="w-8 h-8 rounded-lg bg-emerald-50 text-emerald-600 flex items-center justify-center font-bold">
                                            {{ substr($business->name, 0, 1) }}
                                        </div>
                                        <span class="font-bold text-gray-800">{{ $business->name }}</span>
                                    </div>
                                </td>
                                <td class="px-6 py-4">
                                    <div class="font-medium text-gray-700">{{ $business->owner->full_name }}</div>
                                    <div class="text-[10px] text-gray-400">{{ $business->owner->phone }}</div>
                                </td>
                                <td class="px-6 py-4 text-gray-500 font-medium">
                                    {{ $business->verification_requested_at ? $business->verification_requested_at->format('M d, Y') : $business->created_at->format('M d, Y') }}
                                </td>
                                <td class="px-6 py-4 text-right">
                                    <a href="{{ route('admin.businesses.show', $business) }}" class="inline-flex items-center justify-center px-4 py-1.5 bg-primary text-white rounded-xl text-xs font-bold hover:bg-emerald-600 transition-all">
                                        Review
                                    </a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    @endif
</div>
@endsection
