@extends('layouts.admin')

@section('title', 'Category Management')
@section('header_title', 'Category Management')

@section('content')
<div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
    <!-- Category List -->
    <div class="lg:col-span-2 space-y-4">
        <div class="bg-white rounded-[2rem] border border-gray-100 shadow-sm overflow-hidden">
            <div class="px-6 py-4 border-b border-gray-50 flex items-center justify-between bg-gray-50/30">
                <h3 class="font-bold text-gray-800 text-sm">System Categories</h3>
                <span class="bg-gray-100 text-gray-500 px-3 py-1 rounded-full text-[10px] font-black uppercase">{{ count($categories) }} Total</span>
            </div>
            
            <div class="overflow-x-auto max-h-[700px] overflow-y-auto custom-scrollbar">
                <table class="w-full text-left text-xs">
                    <thead class="bg-white sticky top-0 z-10 border-b border-gray-100">
                        <tr>
                            <th class="px-6 py-4 text-[10px] font-black uppercase text-gray-400">Icon & Name</th>
                            <th class="px-6 py-4 text-[10px] font-black uppercase text-gray-400">Parent</th>
                            <th class="px-6 py-4 text-right text-[10px] font-black uppercase text-gray-400">Action</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-50">
                        @foreach($categories as $cat)
                            <tr class="hover:bg-gray-50 transition-all group">
                                <td class="px-6 py-4">
                                    <div class="flex items-center gap-3">
                                        <div class="w-8 h-8 rounded-lg bg-gray-50 flex items-center justify-center p-1.5 border border-gray-100 group-hover:bg-white transition-colors">
                                            <img src="{{ asset('assets/' . $cat['icon']) }}" class="w-full h-full object-contain opacity-70 group-hover:opacity-100" 
                                                 onerror="this.src='{{ asset('assets/categories/others.png') }}'">
                                        </div>
                                        <div>
                                            <div class="font-bold text-gray-800">{{ $cat['Category'] }}</div>
                                            <div class="text-[9px] text-gray-400 font-medium">ID: {{ $cat['id'] }}</div>
                                        </div>
                                    </div>
                                </td>
                                <td class="px-6 py-4">
                                    @if($cat['parent'] === '0')
                                        <span class="px-2 py-0.5 rounded bg-primary/10 text-primary text-[9px] font-black uppercase">Root</span>
                                    @else
                                        @php
                                            $parent = collect($categories)->firstWhere('id', $cat['parent']);
                                        @endphp
                                        <span class="text-gray-500 font-medium">
                                            {{ $parent['Category'] ?? 'Unknown (' . $cat['parent'] . ')' }}
                                        </span>
                                    @endif
                                </td>
                                <td class="px-6 py-4 text-right">
                                    <div class="flex items-center justify-end gap-1 opacity-0 group-hover:opacity-100 transition-opacity">
                                        <button onclick="editCategory({{ json_encode($cat) }})" class="p-2 text-gray-400 hover:text-primary rounded-lg">
                                            <i class="fa-solid fa-pen-to-square"></i>
                                        </button>
                                        <form action="{{ route('admin.categories.destroy', $cat['id']) }}" method="POST" onsubmit="return confirm('Are you sure you want to delete this category? This might affect listings linked to it.');" class="inline">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="p-2 text-gray-400 hover:text-red-500 rounded-lg">
                                                <i class="fa-solid fa-trash-can"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Add/Edit Form -->
    <div class="lg:col-span-1">
        <div class="bg-white rounded-[2rem] border border-gray-100 shadow-sm p-6 sticky top-24">
            <h3 id="form-title" class="font-black text-gray-900 uppercase tracking-tighter text-lg mb-6">Add New Category</h3>
            
            <form id="category-form" action="{{ route('admin.categories.store') }}" method="POST" class="space-y-5">
                @csrf
                <div id="method-container"></div>

                <div class="space-y-2">
                    <label class="text-[10px] font-black uppercase text-gray-400 ml-1">Category Name</label>
                    <input type="text" name="category" id="input-name" required placeholder="e.g. Smart Electronics" 
                           class="w-full px-4 py-3 rounded-2xl bg-gray-50 border border-gray-100 text-sm focus:bg-white focus:border-primary outline-none transition-all">
                </div>

                <div class="space-y-2">
                    <label class="text-[10px] font-black uppercase text-gray-400 ml-1">Icon Path (from assets/)</label>
                    <input type="text" name="icon" id="input-icon" required placeholder="e.g. categories/electronics.png" 
                           class="w-full px-4 py-3 rounded-2xl bg-gray-50 border border-gray-100 text-sm focus:bg-white focus:border-primary outline-none transition-all">
                </div>

                <div class="space-y-2">
                    <label class="text-[10px] font-black uppercase text-gray-400 ml-1">Parent Category</label>
                    <select name="parent" id="input-parent" required class="w-full px-4 py-3 rounded-2xl bg-gray-50 border border-gray-100 text-sm focus:bg-white focus:border-primary outline-none transition-all">
                        <option value="0">None (Root Category)</option>
                        @foreach($categories as $cat)
                            @if($cat['parent'] === '0')
                                <option value="{{ $cat['id'] }}">{{ $cat['Category'] }}</option>
                            @endif
                        @endforeach
                    </select>
                </div>

                <div class="pt-4 flex gap-2">
                    <button type="submit" id="submit-btn" class="flex-1 py-4 bg-primary text-white font-bold rounded-2xl shadow-lg shadow-primary/20 hover:bg-emerald-600 transition-all">
                        Create Category
                    </button>
                    <button type="button" onclick="resetForm()" id="cancel-btn" class="hidden px-4 py-4 bg-gray-50 text-gray-400 font-bold rounded-2xl hover:bg-gray-100 transition-all">
                        <i class="fa-solid fa-xmark"></i>
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
    function editCategory(category) {
        document.getElementById('form-title').innerText = 'Edit: ' + category.Category;
        document.getElementById('category-form').action = '/admin/categories/' + category.id;
        document.getElementById('method-container').innerHTML = '<input type="hidden" name="_token" value="{{ csrf_token() }}">';
        
        document.getElementById('input-name').value = category.Category;
        document.getElementById('input-icon').value = category.icon;
        document.getElementById('input-parent').value = category.parent;
        
        document.getElementById('submit-btn').innerText = 'Update Category';
        document.getElementById('cancel-btn').classList.remove('hidden');
    }

    function resetForm() {
        document.getElementById('form-title').innerText = 'Add New Category';
        document.getElementById('category-form').action = '{{ route("admin.categories.store") }}';
        document.getElementById('method-container').innerHTML = '';
        
        document.getElementById('input-name').value = '';
        document.getElementById('input-icon').value = '';
        document.getElementById('input-parent').value = '0';
        
        document.getElementById('submit-btn').innerText = 'Create Category';
        document.getElementById('cancel-btn').classList.add('hidden');
    }
</script>
@endsection
