@extends('layouts.admin')

@section('title', 'Verification Queue')
@section('header_title', 'Verification Queue')

@section('content')
<div class="space-y-6">
    <div class="bg-vibrant-orange/5 border border-vibrant-orange/10 p-6 rounded-3xl flex items-center gap-4">
        <div class="w-12 h-12 rounded-2xl bg-vibrant-orange text-white flex items-center justify-center text-xl">
            <i class="fa-solid fa-shield-halved"></i>
        </div>
        <div>
            <h3 class="font-bold text-gray-800">Review Pending Businesses</h3>
            <p class="text-sm text-gray-500">Carefully review the business details before verifying. Verified businesses get a badge and higher visibility.</p>
        </div>
    </div>

    <!-- Businesses Table -->
    <div class="bg-white rounded-3xl border border-gray-100 shadow-sm overflow-hidden">
        <div class="overflow-x-auto">
            <table class="w-full text-left text-sm">
                <thead class="bg-gray-50 text-[10px] font-black uppercase text-gray-400">
                    <tr>
                        <th class="px-6 py-4">Business</th>
                        <th class="px-6 py-4">Owner</th>
                        <th class="px-6 py-4">Requested On</th>
                        <th class="px-6 py-4 text-right">Action</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-50">
                    @forelse($businesses as $business)
                        <tr class="hover:bg-gray-50 transition-all">
                            <td class="px-6 py-4">
                                <div class="flex items-center gap-3">
                                    <div class="w-10 h-10 rounded-xl bg-emerald-50 text-emerald-600 flex items-center justify-center font-bold">
                                        {{ substr($business->name, 0, 1) }}
                                    </div>
                                    <div>
                                        <div class="font-bold text-gray-800">{{ $business->name }}</div>
                                        <div class="text-[10px] font-medium text-gray-400 uppercase">{{ $business->business_category }}</div>
                                    </div>
                                </div>
                            </td>
                            <td class="px-6 py-4">
                                <div class="font-medium text-gray-700">{{ $business->owner->full_name }}</div>
                                <div class="text-[10px] text-gray-400">{{ $business->owner->phone }}</div>
                            </td>
                            <td class="px-6 py-4 text-gray-500 font-medium">
                                {{ $business->verification_requested_at ? $business->verification_requested_at->format('M d, Y') : $business->created_at->format('M d, Y') }}
                            </td>
                            <td class="px-6 py-4 text-right">
                                <div class="flex items-center justify-end gap-2">
                                    <a href="{{ route('admin.businesses.show', $business) }}" class="btn-primary !py-2 !px-4 text-xs">
                                        Review Details
                                    </a>
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="4" class="px-6 py-12 text-center text-gray-400">
                                <i class="fa-solid fa-circle-check text-4xl mb-4 opacity-20"></i>
                                <p class="text-sm font-medium">Current queue is empty. All caught up!</p>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        
        @if($businesses->hasPages())
            <div class="px-6 py-4 bg-gray-50 border-t border-gray-100">
                {{ $businesses->links() }}
            </div>
        @endif
    </div>
</div>
@endsection
