@extends('layouts.admin')

@section('title', 'Business Details')
@section('header_title', 'Business: ' . $business->name)

@section('content')
<div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
    <!-- Business Profile -->
    <div class="lg:col-span-1 space-y-6">
        <div class="bg-white rounded-3xl border border-gray-100 shadow-sm p-8 text-center">
            <div class="w-32 h-32 rounded-3xl bg-emerald-50 text-emerald-600 mx-auto mb-6 flex items-center justify-center text-4xl font-bold ring-4 ring-emerald-50/50">
                {{ substr($business->name, 0, 1) }}
            </div>
            <h2 class="text-xl font-black text-gray-800">{{ $business->name }}</h2>
            <p class="text-sm text-gray-400 font-medium uppercase tracking-widest mt-1">{{ $business->business_category }}</p>
            
            <div class="mt-6 flex items-center justify-center gap-2">
                <span class="px-3 py-1 rounded-full text-[10px] font-black uppercase tracking-wider {{ $business->verification_status === 'verified' ? 'bg-emerald-50 text-emerald-600' : ($business->verification_status === 'pending' ? 'bg-orange-50 text-orange-600' : 'bg-gray-50 text-gray-500') }}">
                    {{ $business->verification_status }}
                </span>
            </div>
        </div>

        <!-- Verification Actions -->
        @if($business->verification_status !== 'verified')
            <div class="bg-white rounded-3xl border border-gray-100 shadow-sm p-6 space-y-6">
                <h3 class="font-bold text-gray-800 flex items-center gap-2">
                    <i class="fa-solid fa-shield-check text-primary"></i>
                    Verification Control
                </h3>

                <form action="{{ route('admin.businesses.verify', $business) }}" method="POST">
                    @csrf
                    <button type="submit" class="w-full py-3 bg-primary text-white font-bold rounded-2xl shadow-lg shadow-primary/20 hover:bg-emerald-600 transition-all flex items-center justify-center gap-2">
                        <i class="fa-solid fa-check-double text-sm"></i>
                        Approve Verification
                    </button>
                </form>

                <div class="relative">
                    <div class="absolute inset-0 flex items-center"><div class="w-full border-t border-gray-50"></div></div>
                    <div class="relative flex justify-center text-[10px]"><span class="px-2 bg-white text-gray-300 font-bold uppercase">OR</span></div>
                </div>

                <form action="{{ route('admin.businesses.reject', $business) }}" method="POST" class="space-y-3">
                    @csrf
                    <label class="text-[10px] font-black uppercase text-gray-400 ml-1">Rejection Reason</label>
                    <textarea name="reason" rows="3" required placeholder="Explain why the verification was rejected..." 
                              class="w-full px-4 py-3 rounded-2xl bg-gray-50 border border-gray-100 text-sm focus:bg-white focus:border-red-500 outline-none transition-all"></textarea>
                    <button type="submit" class="w-full py-2 bg-red-50 text-red-600 font-bold rounded-xl hover:bg-red-100 transition-all text-xs">
                        Reject Verification
                    </button>
                </form>
            </div>
        @else
            <div class="bg-emerald-500 rounded-3xl shadow-lg shadow-emerald-500/20 p-8 text-white relative overflow-hidden">
                <div class="relative z-10">
                    <div class="flex items-center gap-3 mb-4">
                        <i class="fa-solid fa-circle-check text-2xl"></i>
                        <h3 class="text-lg font-black uppercase tracking-tighter">Verified Business</h3>
                    </div>
                    <p class="text-emerald-50 text-sm font-medium leading-relaxed">
                        This business was verified on <br>
                        <span class="font-black">{{ $business->verified_at ? $business->verified_at->format('M d, Y @ H:i') : 'Unknown Date' }}</span>
                    </p>
                </div>
                <i class="fa-solid fa-shield-check absolute -right-4 -bottom-4 text-8xl opacity-10"></i>
            </div>
        @endif

        <!-- Owner Card -->
        <div class="bg-white rounded-3xl border border-gray-100 shadow-sm p-6">
            <h3 class="font-bold text-gray-800 mb-4 flex items-center gap-2">
                <i class="fa-solid fa-user text-primary"></i>
                Business Owner
            </h3>
            <div class="flex items-center gap-4 p-3 bg-gray-50 rounded-2xl border border-gray-100">
                <div class="w-12 h-12 rounded-xl bg-white border border-gray-100 flex items-center justify-center text-gray-400 font-bold text-xl">
                    {{ substr($business->owner->full_name, 0, 1) }}
                </div>
                <div>
                    <a href="{{ route('admin.users.show', $business->owner) }}" class="text-sm font-bold text-gray-800 hover:text-primary transition-colors">{{ $business->owner->full_name }}</a>
                    <div class="text-[10px] font-medium text-gray-400 tracking-wider">MEMBER SINCE {{ $business->owner->created_at->format('Y') }}</div>
                </div>
            </div>
        </div>
    </div>

    <!-- Business Details -->
    <div class="lg:col-span-2 space-y-8">
        <!-- Info Grid -->
        <div class="bg-white rounded-3xl border border-gray-100 shadow-sm p-8 grid grid-cols-1 md:grid-cols-2 gap-8">
            <div class="space-y-6">
                <h3 class="font-black text-gray-900 uppercase tracking-tighter text-lg">General Information</h3>
                <div class="space-y-5">
                    <div class="flex items-start gap-4">
                        <div class="w-10 h-10 rounded-xl bg-gray-50 flex items-center justify-center text-gray-400 shrink-0"><i class="fa-solid fa-envelope"></i></div>
                        <div>
                            <div class="text-[10px] font-black uppercase text-gray-400">Public Email</div>
                            <div class="text-sm font-bold text-gray-700">{{ $business->email }}</div>
                        </div>
                    </div>
                    <div class="flex items-start gap-4">
                        <div class="w-10 h-10 rounded-xl bg-gray-50 flex items-center justify-center text-gray-400 shrink-0"><i class="fa-solid fa-phone"></i></div>
                        <div>
                            <div class="text-[10px] font-black uppercase text-gray-400">Phone Number</div>
                            <div class="text-sm font-bold text-gray-700">{{ $business->primary_phone }}</div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="space-y-6">
                <h3 class="font-black text-gray-900 uppercase tracking-tighter text-lg">Location & Reach</h3>
                <div class="space-y-5">
                    <div class="flex items-start gap-4">
                        <div class="w-10 h-10 rounded-xl bg-gray-50 flex items-center justify-center text-gray-400 shrink-0"><i class="fa-solid fa-location-dot"></i></div>
                        <div>
                            <div class="text-[10px] font-black uppercase text-gray-400">Address</div>
                            <div class="text-sm font-bold text-gray-700">{{ $business->address }}, {{ $business->district }}</div>
                        </div>
                    </div>
                    @if($business->primary_whatsapp)
                        <div class="flex items-start gap-4">
                            <div class="w-10 h-10 rounded-xl bg-emerald-50 flex items-center justify-center text-emerald-500 shrink-0"><i class="fa-brands fa-whatsapp text-lg"></i></div>
                            <div>
                                <div class="text-[10px] font-black uppercase text-gray-400">WhatsApp</div>
                                <div class="text-sm font-bold text-gray-700">{{ $business->primary_whatsapp }}</div>
                            </div>
                        </div>
                    @endif
                </div>
            </div>

            @if($business->description)
                <div class="md:col-span-2 pt-4 border-t border-gray-50">
                    <div class="text-[10px] font-black uppercase text-gray-400 mb-2">Description</div>
                    <p class="text-sm text-gray-600 leading-relaxed">{{ $business->description }}</p>
                </div>
            @endif
        </div>

        <!-- Feedback & Listings -->
        <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
            <!-- Listings Preview -->
            <div class="bg-white rounded-3xl border border-gray-100 shadow-sm overflow-hidden">
                <div class="px-6 py-5 border-b border-gray-50 flex items-center justify-between">
                    <h3 class="font-bold text-gray-800 text-sm">Active Ads</h3>
                    <span class="bg-gray-100 text-gray-600 px-3 py-1 rounded-full text-[10px] font-black">{{ $business->listings->count() }}</span>
                </div>
                @if($business->listings->isNotEmpty())
                    <div class="divide-y divide-gray-50 max-h-[400px] overflow-y-auto custom-scrollbar">
                        @foreach($business->listings as $listing)
                            <div class="px-6 py-4 flex items-center justify-between">
                                <div class="flex items-center gap-3">
                                    <div class="w-10 h-10 rounded-lg bg-gray-50 overflow-hidden border border-gray-100">
                                        @if($listing->thumbnail_url)
                                            <img src="{{ $listing->thumbnail_url }}" class="w-full h-full object-cover">
                                        @endif
                                    </div>
                                    <div class="font-bold text-gray-800 text-xs truncate max-w-[120px]">{{ $listing->title }}</div>
                                </div>
                                <div class="text-[10px] font-black text-primary">{{ number_format($listing->price_amount) }}</div>
                            </div>
                        @endforeach
                    </div>
                @else
                    <div class="p-10 text-center text-gray-300">
                        <i class="fa-solid fa-tags text-4xl mb-4 opacity-20"></i>
                        <p class="text-xs font-bold uppercase">No ads found</p>
                    </div>
                @endif
            </div>

            <!-- Feedback Preview -->
            <div class="bg-white rounded-3xl border border-gray-100 shadow-sm overflow-hidden">
                <div class="px-6 py-5 border-b border-gray-50">
                    <h3 class="font-bold text-gray-800 text-sm">Customer Feedback</h3>
                </div>
                @if($business->feedbacks->isNotEmpty())
                    <div class="divide-y divide-gray-50 max-h-[400px] overflow-y-auto custom-scrollbar">
                        @foreach($business->feedbacks as $item)
                            <div class="px-6 py-4">
                                <div class="flex items-center justify-between mb-2">
                                    <div class="flex items-center gap-1 text-[10px]">
                                        @if($item->sentiment === 'positive')
                                            <span class="text-emerald-500 font-bold bg-emerald-50 px-2 py-0.5 rounded-full uppercase tracking-wider">Positive</span>
                                        @elseif($item->sentiment === 'negative')
                                            <span class="text-red-500 font-bold bg-red-50 px-2 py-0.5 rounded-full uppercase tracking-wider">Negative</span>
                                        @else
                                            <span class="text-gray-500 font-bold bg-gray-50 px-2 py-0.5 rounded-full uppercase tracking-wider">Neutral</span>
                                        @endif
                                    </div>
                                    <span class="text-[10px] text-gray-400 uppercase font-black">{{ $item->created_at->diffForHumans() }}</span>
                                </div>
                                <p class="text-xs text-gray-600 italic">"{{ Str::limit($item->message, 80) }}"</p>
                            </div>
                        @endforeach
                    </div>
                @else
                    <div class="p-10 text-center text-gray-300">
                        <i class="fa-solid fa-comment-slash text-4xl mb-4 opacity-20"></i>
                        <p class="text-xs font-bold uppercase">No feedback yet</p>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection
