# Yilick API Documentation

## Overview

This is a production-ready, API-only authentication and user management system for a classified listing platform. Built with Laravel 12 and JWT authentication.

**Base URL:** `https://your-domain.com/api/v1`

## Authentication

All authenticated endpoints require a Bearer token in the Authorization header:

```
Authorization: Bearer <access_token>
```

## Rate Limiting

| Endpoint Type | Limit | Window |
|--------------|-------|--------|
| Authentication (login/register) | 5 requests | per minute |
| OTP endpoints | 3 requests | per minute |
| Email verification resend | 1 request | per minute |
| General API | 60 requests | per minute |

---

## Authentication Endpoints

### Register

**POST** `/api/v1/auth/register`

Create a new user account.

**Request:**
```json
{
    "full_name": "John Doe",
    "email": "john@example.com",
    "phone": "+1234567890",
    "password": "SecurePass123!",
    "password_confirmation": "SecurePass123!",
    "date_of_birth": "1990-05-15",
    "gender": "male"
}
```

**Response (201 Created):**
```json
{
    "success": true,
    "message": "Registration successful. Please verify your email.",
    "data": {
        "user": {
            "id": 1,
            "full_name": "John Doe",
            "email": "john@example.com",
            "phone": "+1234567890",
            "profile_photo_url": null,
            "date_of_birth": "1990-05-15",
            "gender": "male",
            "status": "active",
            "role": "user",
            "email_verified": false,
            "phone_verified": false,
            "created_at": "2024-01-15T10:30:00+00:00",
            "updated_at": "2024-01-15T10:30:00+00:00"
        },
        "token": {
            "access_token": "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9...",
            "refresh_token": "a1b2c3d4e5f6g7h8i9j0...",
            "token_type": "Bearer",
            "expires_in": 3600
        }
    }
}
```

**Validation Errors (422):**
```json
{
    "success": false,
    "message": "Validation failed.",
    "errors": {
        "email": ["The email has already been taken."],
        "password": ["The password must contain at least one uppercase letter."]
    }
}
```

---

### Login

**POST** `/api/v1/auth/login`

Authenticate user with email or phone.

**Request (Email):**
```json
{
    "login": "john@example.com",
    "password": "SecurePass123!"
}
```

**Request (Phone):**
```json
{
    "login": "+1234567890",
    "password": "SecurePass123!"
}
```

**Response (200 OK):**
```json
{
    "success": true,
    "message": "Login successful.",
    "data": {
        "user": {
            "id": 1,
            "full_name": "John Doe",
            "email": "john@example.com",
            "phone": "+1234567890",
            "profile_photo_url": "https://storage.example.com/profile-photos/abc123.jpg",
            "date_of_birth": "1990-05-15",
            "gender": "male",
            "status": "active",
            "role": "user",
            "email_verified": true,
            "phone_verified": false,
            "created_at": "2024-01-15T10:30:00+00:00",
            "updated_at": "2024-01-15T10:30:00+00:00"
        },
        "token": {
            "access_token": "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9...",
            "refresh_token": "a1b2c3d4e5f6g7h8i9j0...",
            "token_type": "Bearer",
            "expires_in": 3600
        }
    }
}
```

**Error (401 Unauthorized):**
```json
{
    "success": false,
    "message": "Invalid credentials."
}
```

**Error (403 Forbidden - Suspended):**
```json
{
    "success": false,
    "message": "Your account has been suspended. Please contact support."
}
```

---

### Refresh Token

**POST** `/api/v1/auth/refresh`

Refresh access token using refresh token.

**Request:**
```json
{
    "refresh_token": "a1b2c3d4e5f6g7h8i9j0..."
}
```

**Response (200 OK):**
```json
{
    "success": true,
    "message": "Token refreshed successfully.",
    "data": {
        "user": { ... },
        "token": {
            "access_token": "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9...",
            "refresh_token": "new_refresh_token...",
            "token_type": "Bearer",
            "expires_in": 3600
        }
    }
}
```

---

### Logout

**POST** `/api/v1/auth/logout`

🔒 **Requires Authentication**

Invalidate current token.

**Response (200 OK):**
```json
{
    "success": true,
    "message": "Successfully logged out.",
    "data": null
}
```

---

### Logout All Devices

**POST** `/api/v1/auth/logout-all`

🔒 **Requires Authentication**

Invalidate all refresh tokens for the user.

**Response (200 OK):**
```json
{
    "success": true,
    "message": "Successfully logged out from all devices.",
    "data": null
}
```

---

### Get Current User

**GET** `/api/v1/auth/me`

🔒 **Requires Authentication**

**Response (200 OK):**
```json
{
    "success": true,
    "message": "Success",
    "data": {
        "id": 1,
        "full_name": "John Doe",
        "email": "john@example.com",
        "phone": "+1234567890",
        "profile_photo_url": "https://storage.example.com/profile-photos/abc123.jpg",
        "date_of_birth": "1990-05-15",
        "gender": "male",
        "status": "active",
        "role": "user",
        "email_verified": true,
        "phone_verified": false,
        "created_at": "2024-01-15T10:30:00+00:00",
        "updated_at": "2024-01-15T10:30:00+00:00"
    }
}
```

---

### Forgot Password

**POST** `/api/v1/auth/forgot-password`

Send password reset link to email.

**Request:**
```json
{
    "email": "john@example.com"
}
```

**Response (200 OK):**
```json
{
    "success": true,
    "message": "Password reset link sent to your email.",
    "data": null
}
```

---

### Reset Password

**POST** `/api/v1/auth/reset-password`

Reset password using token from email.

**Request:**
```json
{
    "token": "reset_token_from_email",
    "email": "john@example.com",
    "password": "NewSecurePass123!",
    "password_confirmation": "NewSecurePass123!"
}
```

**Response (200 OK):**
```json
{
    "success": true,
    "message": "Password has been reset successfully.",
    "data": null
}
```

---

### Resend Email Verification

**POST** `/api/v1/auth/resend-verification`

🔒 **Requires Authentication**

**Response (200 OK):**
```json
{
    "success": true,
    "message": "Verification email sent.",
    "data": null
}
```

---

### Verify Email

**GET** `/api/v1/auth/verify-email/{id}/{hash}`

Verify email address (link from email).

**Response (200 OK):**
```json
{
    "success": true,
    "message": "Email verified successfully.",
    "data": null
}
```

---

### Send OTP

**POST** `/api/v1/auth/send-otp`

Send OTP for phone/email verification.

**Request:**
```json
{
    "identifier": "+1234567890",
    "type": "phone"
}
```

**Response (200 OK):**
```json
{
    "success": true,
    "message": "OTP sent successfully.",
    "data": {
        "expires_in": 600
    }
}
```

---

### Verify OTP

**POST** `/api/v1/auth/verify-otp`

Verify OTP code.

**Request:**
```json
{
    "identifier": "+1234567890",
    "type": "phone",
    "otp": "123456"
}
```

**Response (200 OK):**
```json
{
    "success": true,
    "message": "OTP verified successfully.",
    "data": null
}
```

---

## User Profile Endpoints

### Get Profile

**GET** `/api/v1/user/profile`

🔒 **Requires Authentication**

**Response (200 OK):**
```json
{
    "success": true,
    "message": "Success",
    "data": {
        "id": 1,
        "full_name": "John Doe",
        "email": "john@example.com",
        "phone": "+1234567890",
        "profile_photo_url": "https://storage.example.com/profile-photos/abc123.jpg",
        "date_of_birth": "1990-05-15",
        "gender": "male",
        "status": "active",
        "role": "user",
        "email_verified": true,
        "phone_verified": true,
        "created_at": "2024-01-15T10:30:00+00:00",
        "updated_at": "2024-01-15T10:30:00+00:00"
    }
}
```

---

### Update Profile

**PUT** `/api/v1/user/profile`

🔒 **Requires Authentication**

**Request (JSON):**
```json
{
    "full_name": "John Smith",
    "phone": "+1987654321",
    "date_of_birth": "1990-06-20",
    "gender": "male"
}
```

**Request (Multipart Form - with photo):**
```
Content-Type: multipart/form-data

full_name: John Smith
profile_photo: [file]
```

**Response (200 OK):**
```json
{
    "success": true,
    "message": "Profile updated successfully.",
    "data": {
        "id": 1,
        "full_name": "John Smith",
        "email": "john@example.com",
        "phone": "+1987654321",
        "profile_photo_url": "https://storage.example.com/profile-photos/new123.jpg",
        "date_of_birth": "1990-06-20",
        "gender": "male",
        "status": "active",
        "role": "user",
        "email_verified": true,
        "phone_verified": false,
        "created_at": "2024-01-15T10:30:00+00:00",
        "updated_at": "2024-01-15T11:00:00+00:00"
    }
}
```

---

### Change Password

**PUT** `/api/v1/user/change-password`

🔒 **Requires Authentication**

**Request:**
```json
{
    "current_password": "OldSecurePass123!",
    "password": "NewSecurePass456!",
    "password_confirmation": "NewSecurePass456!"
}
```

**Response (200 OK):**
```json
{
    "success": true,
    "message": "Password changed successfully. Other sessions have been logged out.",
    "data": null
}
```

---

### Remove Profile Photo

**DELETE** `/api/v1/user/profile-photo`

🔒 **Requires Authentication**

**Response (200 OK):**
```json
{
    "success": true,
    "message": "Profile photo removed successfully.",
    "data": { ... }
}
```

---

### Delete Account

**DELETE** `/api/v1/user/account`

🔒 **Requires Authentication**

Soft delete user account.

**Request:**
```json
{
    "password": "CurrentPassword123!",
    "reason": "No longer using the service"
}
```

**Response (200 OK):**
```json
{
    "success": true,
    "message": "Account deleted successfully.",
    "data": null
}
```

---

## Admin Endpoints

All admin endpoints require authentication and admin role.

### List Users

**GET** `/api/v1/admin/users`

🔒 **Requires Authentication + Admin Role**

**Query Parameters:**
| Parameter | Type | Description |
|-----------|------|-------------|
| search | string | Search by name, email, or phone |
| status | string | Filter by status (active, suspended, deleted) |
| role | string | Filter by role (user, seller, admin) |
| sort_by | string | Sort field (created_at, full_name, email, status, role) |
| sort_order | string | Sort direction (asc, desc) |
| per_page | integer | Items per page (1-100, default: 15) |
| include_deleted | boolean | Include soft-deleted users |

**Response (200 OK):**
```json
{
    "success": true,
    "message": "Success",
    "data": {
        "data": [
            {
                "id": 1,
                "full_name": "John Doe",
                "email": "john@example.com",
                "phone": "+1234567890",
                "profile_photo_url": null,
                "date_of_birth": "1990-05-15",
                "gender": "male",
                "status": "active",
                "role": "user",
                "email_verified": true,
                "phone_verified": false,
                "created_at": "2024-01-15T10:30:00+00:00",
                "updated_at": "2024-01-15T10:30:00+00:00"
            }
        ],
        "meta": {
            "current_page": 1,
            "from": 1,
            "last_page": 10,
            "per_page": 15,
            "to": 15,
            "total": 150
        }
    }
}
```

---

### Get User Statistics

**GET** `/api/v1/admin/users/statistics`

🔒 **Requires Authentication + Admin Role**

**Response (200 OK):**
```json
{
    "success": true,
    "message": "Success",
    "data": {
        "total_users": 1500,
        "active_users": 1400,
        "suspended_users": 50,
        "deleted_users": 50,
        "verified_emails": 1200,
        "verified_phones": 800,
        "by_role": {
            "users": 1300,
            "sellers": 180,
            "admins": 20
        },
        "registrations_today": 25,
        "registrations_this_week": 150,
        "registrations_this_month": 500
    }
}
```

---

### Get User

**GET** `/api/v1/admin/users/{id}`

🔒 **Requires Authentication + Admin Role**

**Response (200 OK):**
```json
{
    "success": true,
    "message": "Success",
    "data": {
        "id": 1,
        "full_name": "John Doe",
        ...
    }
}
```

---

### Update User Status

**PUT** `/api/v1/admin/users/{id}/status`

🔒 **Requires Authentication + Admin Role**

**Request:**
```json
{
    "status": "suspended",
    "reason": "Violation of terms of service"
}
```

**Response (200 OK):**
```json
{
    "success": true,
    "message": "User status changed from active to suspended.",
    "data": { ... }
}
```

---

### Update User Role

**PUT** `/api/v1/admin/users/{id}/role`

🔒 **Requires Authentication + Admin Role**

**Request:**
```json
{
    "role": "seller"
}
```

**Response (200 OK):**
```json
{
    "success": true,
    "message": "User role changed from user to seller.",
    "data": { ... }
}
```

---

### Restore User

**POST** `/api/v1/admin/users/{id}/restore`

🔒 **Requires Authentication + Admin Role**

Restore a soft-deleted user.

**Response (200 OK):**
```json
{
    "success": true,
    "message": "User restored successfully.",
    "data": { ... }
}
```

---

### Force Delete User

**DELETE** `/api/v1/admin/users/{id}/force`

🔒 **Requires Authentication + Admin Role**

Permanently delete a user.

**Response (200 OK):**
```json
{
    "success": true,
    "message": "User permanently deleted.",
    "data": null
}
```

---

## Error Responses

### 401 Unauthorized
```json
{
    "success": false,
    "message": "Token has expired."
}
```

### 403 Forbidden
```json
{
    "success": false,
    "message": "You do not have permission to access this resource."
}
```

### 404 Not Found
```json
{
    "success": false,
    "message": "Resource not found."
}
```

### 422 Validation Error
```json
{
    "success": false,
    "message": "Validation failed.",
    "errors": {
        "field_name": ["Error message"]
    }
}
```

### 429 Too Many Requests
```json
{
    "success": false,
    "message": "Too many authentication attempts. Please try again later.",
    "retry_after": 60
}
```

### 500 Server Error
```json
{
    "success": false,
    "message": "An unexpected error occurred."
}
```

---

## Security Headers

All API responses include the following security headers:

| Header | Value |
|--------|-------|
| X-Content-Type-Options | nosniff |
| X-Frame-Options | DENY |
| X-XSS-Protection | 1; mode=block |
| Strict-Transport-Security | max-age=31536000; includeSubDomains |
| Content-Security-Policy | default-src 'none'; frame-ancestors 'none' |
| Referrer-Policy | strict-origin-when-cross-origin |
| Cache-Control | no-store, no-cache, must-revalidate |

---

## Password Requirements

- Minimum 8 characters
- At least one uppercase letter
- At least one lowercase letter
- At least one number
- At least one special character
- Must not appear in known data breaches

---

## Profile Photo Requirements

- Allowed formats: JPEG, JPG, PNG, GIF, WebP
- Maximum file size: 5MB
- Minimum dimensions: 100x100 pixels
- Maximum dimensions: 4096x4096 pixels
