<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class PremiumPackageSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $packages = [
            [
                'name' => 'Basic',
                'slug' => 'basic',
                'description' => 'Perfect for individuals and small sellers',
                'price' => 999.00,
                'currency' => 'UGX',
                'duration_days' => 30,
                'max_listings' => 10,
                'max_featured_listings' => 2,
                'max_bumps_per_month' => 5,
                'auto_bump_enabled' => true,
                'auto_bump_interval_hours' => 24,
                'max_images_per_listing' => 8,
                'priority_support' => false,
                'verified_badge' => false,
                'analytics_access' => true,
                'remove_ads' => false,
                'is_active' => true,
                'sort_order' => 1,
                'features' => [
                    '10 active listings',
                    '2 featured listings per month',
                    '5 manual bumps per month',
                    'Unlimited auto-bumps every 24 hours',
                    'Up to 8 images per listing',
                    'Basic analytics',
                    'Email support',
                ],
            ],
            [
                'name' => 'Pro',
                'slug' => 'pro',
                'description' => 'Best for growing businesses',
                'price' => 2999.00,
                'currency' => 'UGX',
                'duration_days' => 30,
                'max_listings' => 50,
                'max_featured_listings' => 10,
                'max_bumps_per_month' => 20,
                'max_images_per_listing' => 15,
                'priority_support' => true,
                'verified_badge' => true,
                'analytics_access' => true,
                'remove_ads' => true,
                'is_active' => true,
                'sort_order' => 2,
                'features' => [
                    '50 active listings',
                    '10 featured listings per month',
                    '20 bumps per month',
                    'Up to 15 images per listing',
                    'Advanced analytics',
                    'Verified badge',
                    'Priority support',
                    'Ad-free experience',
                ],
            ],
            [
                'name' => 'Premium',
                'slug' => 'premium',
                'description' => 'For power sellers and large businesses',
                'price' => 5999.00,
                'currency' => 'UGX',
                'duration_days' => 30,
                'max_listings' => 200,
                'max_featured_listings' => 30,
                'max_bumps_per_month' => 100,
                'max_images_per_listing' => 20,
                'priority_support' => true,
                'verified_badge' => true,
                'analytics_access' => true,
                'remove_ads' => true,
                'is_active' => true,
                'sort_order' => 3,
                'features' => [
                    '200 active listings',
                    '30 featured listings per month',
                    '100 bumps per month',
                    'Up to 20 images per listing',
                    'Advanced analytics & insights',
                    'Verified badge',
                    'Priority 24/7 support',
                    'Ad-free experience',
                    'Dedicated account manager',
                ],
            ],
        ];

        foreach ($packages as $package) {
            \App\Models\PremiumPackage::updateOrCreate(
                ['slug' => $package['slug']],
                $package
            );
        }
    }
}
