<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('listings', function (Blueprint $table) {
            $table->boolean('is_featured')->default(false)->after('promoted_rank');
            $table->timestamp('featured_until')->nullable()->after('is_featured');
            $table->foreignId('subscription_id')->nullable()->constrained('user_subscriptions')->onDelete('set null')->after('featured_until');
            
            $table->index('is_featured');
            $table->index('featured_until');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('listings', function (Blueprint $table) {
            $table->dropForeign(['subscription_id']);
            $table->dropColumn(['is_featured', 'featured_until', 'subscription_id']);
        });
    }
};
