<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (!Schema::hasTable('listings')) {
            return;
        }

        Schema::table('listings', function (Blueprint $table) {
            if (!Schema::hasColumn('listings', 'impressions_count')) {
                $table->unsignedBigInteger('impressions_count')->default(0)->after('unique_views_count');
            }
            if (!Schema::hasColumn('listings', 'clicks_count')) {
                $table->unsignedBigInteger('clicks_count')->default(0)->after('impressions_count');
            }
            if (!Schema::hasColumn('listings', 'phone_reveals_count')) {
                $table->unsignedBigInteger('phone_reveals_count')->default(0)->after('clicks_count');
            }
            if (!Schema::hasColumn('listings', 'whatsapp_clicks_count')) {
                $table->unsignedBigInteger('whatsapp_clicks_count')->default(0)->after('phone_reveals_count');
            }
            if (!Schema::hasColumn('listings', 'shares_count')) {
                $table->unsignedBigInteger('shares_count')->default(0)->after('whatsapp_clicks_count');
            }
        });
    }

    public function down(): void
    {
        if (!Schema::hasTable('listings')) {
            return;
        }

        Schema::table('listings', function (Blueprint $table) {
            $columns = ['impressions_count', 'clicks_count', 'phone_reveals_count', 'whatsapp_clicks_count', 'shares_count'];
            foreach ($columns as $column) {
                if (Schema::hasColumn('listings', $column)) {
                    $table->dropColumn($column);
                }
            }
        });
    }
};
