<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (!Schema::hasTable('listings')) {
            return;
        }

        Schema::table('listings', function (Blueprint $table) {
            if (!Schema::hasColumn('listings', 'allow_pos')) {
                $table->boolean('allow_pos')->default(false)->after('barcode');
            }
        });
    }

    public function down(): void
    {
        if (!Schema::hasTable('listings')) {
            return;
        }

        Schema::table('listings', function (Blueprint $table) {
            if (Schema::hasColumn('listings', 'allow_pos')) {
                $table->dropColumn('allow_pos');
            }
        });
    }
};
