<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (!Schema::hasTable('listing_media')) {
            return;
        }

        Schema::table('listing_media', function (Blueprint $table) {
            if (!Schema::hasColumn('listing_media', 'content_hash')) {
                $table->string('content_hash', 64)->nullable()->after('size_bytes');
            }
        });

        $dbName = DB::getDatabaseName();
        $hasIndex = !empty(DB::select(
            'SELECT 1 FROM information_schema.statistics WHERE table_schema = ? AND table_name = ? AND index_name = ? LIMIT 1',
            [$dbName, 'listing_media', 'lm_listing_hash_idx']
        ));

        if (!$hasIndex) {
            Schema::table('listing_media', function (Blueprint $table) {
                $table->index(['listing_id', 'content_hash'], 'lm_listing_hash_idx');
            });
        }
    }

    public function down(): void
    {
        if (!Schema::hasTable('listing_media')) {
            return;
        }

        $dbName = DB::getDatabaseName();
        $hasIndex = !empty(DB::select(
            'SELECT 1 FROM information_schema.statistics WHERE table_schema = ? AND table_name = ? AND index_name = ? LIMIT 1',
            [$dbName, 'listing_media', 'lm_listing_hash_idx']
        ));

        Schema::table('listing_media', function (Blueprint $table) use ($hasIndex) {
            if ($hasIndex) {
                $table->dropIndex('lm_listing_hash_idx');
            }

            if (Schema::hasColumn('listing_media', 'content_hash')) {
                $table->dropColumn('content_hash');
            }
        });
    }
};
