<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (!Schema::hasTable('business_feedback_responses')) {
            Schema::create('business_feedback_responses', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('business_feedback_id');
                $table->unsignedBigInteger('business_id');
                $table->unsignedBigInteger('responded_by_user_id')->nullable();

                $table->text('message');
                $table->timestamps();
            });
        }

        $hasForeignKey = function (string $constraintName): bool {
            $row = DB::selectOne(
                "SELECT 1 FROM information_schema.TABLE_CONSTRAINTS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'business_feedback_responses' AND CONSTRAINT_NAME = ? AND CONSTRAINT_TYPE = 'FOREIGN KEY' LIMIT 1",
                [$constraintName]
            );

            return $row !== null;
        };

        $hasIndex = function (string $indexName): bool {
            $row = DB::selectOne(
                "SELECT 1 FROM information_schema.STATISTICS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'business_feedback_responses' AND INDEX_NAME = ? LIMIT 1",
                [$indexName]
            );

            return $row !== null;
        };

        if (!$hasForeignKey('bfr_feedback_fk')) {
            Schema::table('business_feedback_responses', function (Blueprint $table) {
                $table->foreign('business_feedback_id', 'bfr_feedback_fk')
                    ->references('id')
                    ->on('business_feedbacks')
                    ->onDelete('cascade');
            });
        }

        if (!$hasForeignKey('bfr_business_fk')) {
            Schema::table('business_feedback_responses', function (Blueprint $table) {
                $table->foreign('business_id', 'bfr_business_fk')
                    ->references('id')
                    ->on('businesses')
                    ->onDelete('cascade');
            });
        }

        if (!$hasForeignKey('bfr_responded_by_fk')) {
            Schema::table('business_feedback_responses', function (Blueprint $table) {
                $table->foreign('responded_by_user_id', 'bfr_responded_by_fk')
                    ->references('id')
                    ->on('users')
                    ->nullOnDelete();
            });
        }

        if (!$hasIndex('bfr_business_feedback_idx')) {
            Schema::table('business_feedback_responses', function (Blueprint $table) {
                $table->index(['business_id', 'business_feedback_id'], 'bfr_business_feedback_idx');
            });
        }
    }

    public function down(): void
    {
        Schema::dropIfExists('business_feedback_responses');
    }
};
