<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('businesses', function (Blueprint $table) {
            $table->id();
            $table->foreignId('owner_user_id')->constrained('users')->onDelete('cascade');

            $table->string('name');
            $table->text('description')->nullable();
            $table->string('business_type')->nullable();
            $table->string('business_category')->nullable();

            $table->string('slug')->unique();

            $table->string('address')->nullable();
            $table->string('district')->nullable();

            $table->string('website')->nullable();
            $table->string('facebook_url')->nullable();
            $table->string('instagram_url')->nullable();
            $table->string('x_url')->nullable();
            $table->string('linkedin_url')->nullable();
            $table->string('youtube_url')->nullable();
            $table->string('tiktok_url')->nullable();

            $table->string('logo')->nullable();
            $table->string('cover')->nullable();
            $table->string('primary_color')->nullable();
            $table->string('secondary_color')->nullable();

            $table->string('primary_phone')->nullable();
            $table->string('secondary_phone')->nullable();
            $table->string('primary_whatsapp')->nullable();
            $table->string('secondary_whatsapp')->nullable();

            $table->boolean('is_feedback_enabled')->default(true);
            $table->boolean('is_chat_enabled')->default(true);
            $table->boolean('allow_push_notifications')->default(true);
            $table->boolean('allow_email_notifications')->default(true);
            $table->boolean('allow_sms_notifications')->default(true);

            $table->string('verification_status')->default('unverified');
            $table->timestamp('verification_requested_at')->nullable();
            $table->timestamp('verified_at')->nullable();
            $table->foreignId('verified_by_user_id')->nullable()->constrained('users')->nullOnDelete();
            $table->text('verification_notes')->nullable();

            $table->timestamps();
            $table->softDeletes();

            $table->index(['owner_user_id', 'verification_status']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('businesses');
    }
};
