<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Third Party Services
    |--------------------------------------------------------------------------
    |
    | This file is for storing the credentials for third party services such
    | as Mailgun, Postmark, AWS and more. This file provides the de facto
    | location for this type of information, allowing packages to have
    | a conventional file to locate the various service credentials.
    |
    */

    'postmark' => [
        'key' => env('POSTMARK_API_KEY'),
    ],

    'resend' => [
        'key' => env('RESEND_API_KEY'),
    ],

    'ses' => [
        'key' => env('AWS_ACCESS_KEY_ID'),
        'secret' => env('AWS_SECRET_ACCESS_KEY'),
        'region' => env('AWS_DEFAULT_REGION', 'us-east-1'),
    ],

    'slack' => [
        'notifications' => [
            'bot_user_oauth_token' => env('SLACK_BOT_USER_OAUTH_TOKEN'),
            'channel' => env('SLACK_BOT_USER_DEFAULT_CHANNEL'),
        ],
    ],

    'egosms' => [
        'base_url' => env('EGOSMS_BASE_URL', 'https://www.egosms.co/api/v1/plain/'),
        'username' => env('EGOSMS_USERNAME'),
        'password' => env('EGOSMS_PASSWORD'),
        'sender' => env('EGOSMS_SENDER', env('APP_NAME', 'Yilick')),
        'priority' => (int) env('EGOSMS_PRIORITY', 0),
    ],

    'whatsapp' => [
        'access_token' => env('WHATSAPP_ACCESS_TOKEN'),
        'phone_number_id' => env('WHATSAPP_PHONE_NUMBER_ID'),
        'version' => env('WHATSAPP_GRAPH_VERSION', 'v20.0'),
        'otp_template_name' => env('WHATSAPP_OTP_TEMPLATE_NAME'),
        'otp_template_language' => env('WHATSAPP_OTP_TEMPLATE_LANGUAGE', 'en_US'),
        'otp_template_params' => env('WHATSAPP_OTP_TEMPLATE_PARAMS', 'otp,minutes'),
    ],

    'google_vision' => [
        'api_key' => env('GOOGLE_VISION_API_KEY'),
    ],

    'openai' => [
        'api_key' => env('OPENAI_API_KEY'),
        'model' => env('OPENAI_MODEL', 'gpt-4o-mini'),
    ],

    'fcm' => [
        'service_account' => env('FCM_SERVICE_ACCOUNT_PATH', storage_path('app/firebase/service-account.json')),
        'project_id' => env('FCM_PROJECT_ID'),
    ],
    
         'relworx' => [
        'api_key' => env('RELWORX_API_KEY'),
        'account_no' => env('RELWORX_ACCOUNT_NO'),
        'base_url' => env('RELWORX_BASE_URL', 'https://payments.relworx.com/api/'),
        'webhook_secret' => env('RELWORX_WEBHOOK_SECRET'),
    ],

];
