<?php

namespace App\Services;

use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

class PahappaSmsService
{
    public function send(string $number, string $message, ?string $sender = null, ?int $priority = null): bool
    {
        $baseUrl = (string) config('services.egosms.base_url', 'https://www.egosms.co/api/v1/plain/');
        $username = (string) config('services.egosms.username');
        $password = (string) config('services.egosms.password');
        $sender = $sender ?? (string) config('services.egosms.sender');
        $priority = $priority ?? (int) config('services.egosms.priority', 0);

        if ($username === '' || $password === '' || $sender === '') {
            throw new \RuntimeException('EgoSMS credentials are not configured. Set EGOSMS_USERNAME, EGOSMS_PASSWORD, and EGOSMS_SENDER.');
        }

        $params = [
            'number' => $number,
            'message' => $message,
            'username' => $username,
            'password' => $password,
            'sender' => $sender,
            'priority' => $priority,
        ];

        $response = Http::timeout(15)->retry(2, 250)->get($baseUrl, $params);

        if (!$response->successful()) {
            Log::warning('EgoSMS request failed', [
                'status' => $response->status(),
                'body' => $response->body(),
            ]);

            return false;
        }

        $body = trim((string) $response->body());
        $normalized = strtolower($body);

        if ($normalized === 'ok' || str_contains($normalized, 'ok')) {
            return true;
        }

        Log::warning('EgoSMS returned non-ok response', [
            'body' => $body,
        ]);

        return false;
    }
}
