<?php

namespace App\Policies;

use App\Models\Business;
use App\Models\BusinessMembership;
use App\Models\User;

class BusinessPolicy
{
    public function view(User $user, Business $business): bool
    {
        return $business->owner_user_id == $user->id
            || $business->memberships()->where('user_id', $user->id)->exists();
    }

    public function update(User $user, Business $business): bool
    {
        if ($business->owner_user_id == $user->id) {
            return true;
        }

        $role = $business->memberships()->where('user_id', $user->id)->value('role');

        return in_array($role, [
            BusinessMembership::ROLE_MANAGER,
            BusinessMembership::ROLE_OWNER,
        ], true);
    }

    public function manageListings(User $user, Business $business): bool
    {
        if ($business->owner_user_id == $user->id) {
            return true;
        }

        $role = $business->memberships()->where('user_id', $user->id)->value('role');

        return in_array($role, [
            BusinessMembership::ROLE_LISTINGS_MANAGER,
            BusinessMembership::ROLE_MANAGER,
            BusinessMembership::ROLE_OWNER,
        ], true);
    }

    public function delete(User $user, Business $business): bool
    {
        return $business->owner_user_id == $user->id;
    }

    public function manageMembers(User $user, Business $business): bool
    {
        if ($business->owner_user_id == $user->id) {
            return true;
        }

        $role = $business->memberships()->where('user_id', $user->id)->value('role');

        return in_array($role, [
            BusinessMembership::ROLE_MANAGER,
            BusinessMembership::ROLE_OWNER,
        ], true);
    }

    public function invite(User $user, Business $business): bool
    {
        return $this->manageMembers($user, $business);
    }

    public function transferOwnership(User $user, Business $business): bool
    {
        return $business->owner_user_id == $user->id;
    }

    public function requestVerification(User $user, Business $business): bool
    {
        return $this->update($user, $business);
    }
}
