<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use App\Models\Listing;

class AdLimitReachedNotification extends Notification implements ShouldQueue
{
    use Queueable;

    private Listing $listing;

    /**
     * Create a new notification instance.
     */
    public function __construct(Listing $listing)
    {
        $this->listing = $listing;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail', 'database'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Action Required: Ad Limit Reached')
            ->greeting('Hello ' . $notifiable->name . ',')
            ->line('Your ad "' . $this->listing->title . '" could not be published because you have reached the listing limit for your current package.')
            ->line('To publish more ads and unlock premium features, please upgrade your subscription.')
            ->action('Upgrade Package', url('https://yilick.ug/membership'))
            ->line('Thank you for using Yilick!');
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            'listing_id' => $this->listing->id,
            'listing_title' => $this->listing->title,
            'message' => 'Your ad "' . $this->listing->title . '" could not be published because you have reached your package limit. Upgrade now!',
            'type' => 'ad_limit_reached',
            'action_url' => '/membership'
        ];
    }
}
