<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PosCustomerLedger extends Model
{
    protected $table = 'pos_customer_ledger';

    protected $fillable = [
        'pos_customer_id',
        'business_id',
        'pos_order_id',
        'type',
        'payment_method',
        'amount',
        'notes',
    ];

    protected $casts = [
        'amount' => 'decimal:2',
    ];

    public function customer(): \Illuminate\Database\Eloquent\Relations\BelongsTo
    {
        return $this->belongsTo(PosCustomer::class, 'pos_customer_id');
    }

    public function business(): \Illuminate\Database\Eloquent\Relations\BelongsTo
    {
        return $this->belongsTo(Business::class);
    }

    public function order(): \Illuminate\Database\Eloquent\Relations\BelongsTo
    {
        return $this->belongsTo(PosOrder::class, 'pos_order_id');
    }
}
