<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ListingInteraction extends Model
{
    const TYPE_PHONE_REVEAL = 'phone_reveal';
    const TYPE_WHATSAPP_CLICK = 'whatsapp_click';
    const TYPE_EMAIL_CLICK = 'email_click';
    const TYPE_SHARE = 'share';
    const TYPE_FAVORITE = 'favorite';
    const TYPE_REPORT = 'report';

    protected $fillable = [
        'listing_id',
        'user_id',
        'interaction_type',
        'ip_address',
        'session_id',
        'metadata',
        'interacted_at',
    ];

    protected function casts(): array
    {
        return [
            'metadata' => 'array',
            'interacted_at' => 'datetime',
        ];
    }

    public function listing(): BelongsTo
    {
        return $this->belongsTo(Listing::class);
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}
