<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class InventoryBatch extends Model
{
    use HasFactory;

    protected $fillable = [
        'business_id',
        'listing_id',
        'original_quantity',
        'remaining_store_quantity',
        'remaining_shop_quantity',
        'cost_price',
        'received_at',
        'supplier',
        'reference_note',
    ];

    protected $casts = [
        'original_quantity' => 'integer',
        'remaining_store_quantity' => 'integer',
        'remaining_shop_quantity' => 'integer',
        'cost_price' => 'decimal:2',
        'received_at' => 'datetime',
    ];

    public function business(): BelongsTo
    {
        return $this->belongsTo(Business::class);
    }

    public function listing(): BelongsTo
    {
        return $this->belongsTo(Listing::class);
    }
}
