<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Support\Facades\Storage;

class BusinessFeedbackAttachment extends Model
{
    protected $fillable = [
        'business_feedback_id',
        'business_feedback_response_id',
        'path',
        'mime_type',
        'size_bytes',
    ];

    protected function casts(): array
    {
        return [
            'size_bytes' => 'integer',
        ];
    }

    public function feedback(): BelongsTo
    {
        return $this->belongsTo(BusinessFeedback::class, 'business_feedback_id');
    }

    public function response(): BelongsTo
    {
        return $this->belongsTo(BusinessFeedbackResponse::class, 'business_feedback_response_id');
    }

    public function getUrlAttribute(): ?string
    {
        if (!$this->path) {
            return null;
        }

        if (filter_var($this->path, FILTER_VALIDATE_URL)) {
            return $this->path;
        }

        return Storage::disk('public')->url($this->path);
    }
}
