<?php

namespace App\Mail;

use App\Models\Message;
use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class NewMessageNotification extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;

    public $messageModel;
    public $sender;
    public $recipientName;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(Message $messageModel, User $sender, string $recipientName)
    {
        $this->messageModel = $messageModel;
        $this->sender = $sender;
        $this->recipientName = $recipientName;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $subject = 'New message from ' . ($this->sender->full_name ?? $this->sender->username);

        return $this->subject($subject)
                    ->view('emails.new_message');
    }
}
