<?php

namespace App\Mail;

use App\Models\LoginSession;
use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class LoginNoticeEmail extends Mailable
{
    use Queueable, SerializesModels;

    public function __construct(
        public User $user,
        public LoginSession $session
    ) {
    }

    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'New login to ' . config('app.name'),
        );
    }

    public function content(): Content
    {
        return new Content(
            html: 'emails.login-notice',
        );
    }

    public function attachments(): array
    {
        return [];
    }
}
