<?php

namespace App\Mail;

use App\Models\Business;
use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class BusinessMemberRemovedEmail extends Mailable
{
    use Queueable, SerializesModels;

    public function __construct(
        public Business $business,
        public User $user,
        public bool $selfRemoved = false
    ) {
    }

    public function envelope(): Envelope
    {
        $subject = $this->selfRemoved
            ? "You have left {$this->business->name}"
            : "Access removed: {$this->business->name}";

        return new Envelope(
            subject: $subject,
        );
    }

    public function content(): Content
    {
        return new Content(
            html: 'emails.business-member-removed',
        );
    }

    public function attachments(): array
    {
        return [];
    }
}
