<?php

namespace App\Mail;

use App\Models\Business;
use App\Models\BusinessInvitation;
use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class BusinessInvitationStatusEmail extends Mailable
{
    use Queueable, SerializesModels;

    public function __construct(
        public Business $business,
        public BusinessInvitation $invite,
        public User $inviter,
        public User $invitee,
        public string $status,
        public string $recipientType
    ) {
    }

    public function envelope(): Envelope
    {
        $statusWord = $this->status === 'accepted' ? 'Accepted' : 'Declined';

        if ($this->recipientType === 'inviter') {
            $inviteeName = $this->invitee->full_name ?? $this->invitee->email;
            return new Envelope(
                subject: "Invitation {$statusWord}: {$inviteeName} · {$this->business->name}",
            );
        }

        return new Envelope(
            subject: "Invitation {$statusWord}: {$this->business->name}",
        );
    }

    public function content(): Content
    {
        return new Content(
            html: 'emails.business-invitation-status',
        );
    }

    public function attachments(): array
    {
        return [];
    }
}
