<?php

namespace App\Mail;

use App\Models\Business;
use App\Models\BusinessInvitation;
use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class BusinessInvitationEmail extends Mailable
{
    use Queueable, SerializesModels;

    public function __construct(
        public Business $business,
        public BusinessInvitation $invite,
        public User $inviter,
        public User $invitee
    ) {
    }

    public function envelope(): Envelope
    {
        return new Envelope(
            subject: "You're invited to manage {$this->business->name} on " . config('app.name'),
        );
    }

    public function content(): Content
    {
        return new Content(
            html: 'emails.business-invitation',
        );
    }

    public function attachments(): array
    {
        return [];
    }
}
