<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ListingMediaResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'type' => $this->type,
            'path' => $this->path,
            'watermarked_path' => $this->watermarked_path,
            'url' => $this->path ? \Illuminate\Support\Facades\Storage::disk('public')->url($this->path) : null,
            'watermarked_url' => $this->watermarked_path ? \Illuminate\Support\Facades\Storage::disk('public')->url($this->watermarked_path) : null,
            'tags' => $this->tags ?? [],
            'content_hash' => $this->content_hash,
            'mime_type' => $this->mime_type,
            'size_bytes' => $this->size_bytes,
            'sort_order' => $this->sort_order,
            'is_primary' => (bool) $this->is_primary,
            'created_at' => $this->created_at?->toIso8601String(),
        ];
    }
}
