<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ConversationResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $user = auth('api')->user();

        return [
            'id' => $this->id,
            'listing' => new ListingResource($this->whenLoaded('listing')),
            'buyer' => new UserResource($this->whenLoaded('buyer')),
            'business' => new BusinessResource($this->whenLoaded('business')),
            'last_message' => new MessageResource($this->whenLoaded('latestMessage')),
            'last_message_at' => $this->last_message_at?->toIso8601String(),
            'unread_count' => $this->messages()
                ->where('sender_id', '!=', $user->id)
                ->whereNull('read_at')
                ->count(),
            'created_at' => $this->created_at?->toIso8601String(),
        ];
    }
}
