<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class BusinessFeedbackResponseResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'business_feedback_id' => $this->business_feedback_id,
            'business_id' => $this->business_id,
            'responded_by_user_id' => $this->responded_by_user_id,
            'responded_by_user' => $this->whenLoaded('respondedBy', fn () => new UserResource($this->respondedBy)),
            'message' => $this->message,
            'attachments' => BusinessFeedbackAttachmentResource::collection($this->whenLoaded('attachments')),
            'created_at' => $this->created_at?->toIso8601String(),
            'updated_at' => $this->updated_at?->toIso8601String(),
        ];
    }
}
