<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class AuthResource extends JsonResource
{
    private string $accessToken;
    private string $refreshToken;
    private int $expiresIn;

    public function __construct($resource, string $accessToken, string $refreshToken, int $expiresIn)
    {
        parent::__construct($resource);
        $this->accessToken = $accessToken;
        $this->refreshToken = $refreshToken;
        $this->expiresIn = $expiresIn;
    }

    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'user' => new UserResource($this->resource),
            'token' => [
                'access_token' => $this->accessToken,
                'refresh_token' => $this->refreshToken,
                'token_type' => 'bearer',
                'expires_in' => $this->expiresIn,
            ]
        ];
    }
}
