<?php

namespace App\Http\Requests\Listing;

use App\Models\Listing;
use Illuminate\Foundation\Http\FormRequest;

class CreateListingRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'title' => ['required', 'string', 'max:255'],
            'description' => ['required', 'string', 'max:20000'],
            'category' => ['sometimes', 'nullable', 'string', 'max:120'],
            'sub_category' => ['sometimes', 'nullable', 'string', 'max:120'],
            'sub_sub_category' => ['sometimes', 'nullable', 'string', 'max:120'],

            'price_amount' => ['sometimes', 'nullable', 'numeric', 'min:0'],
            'purchase_price_amount' => ['sometimes', 'nullable', 'numeric', 'min:0'],
            'currency' => ['sometimes', 'string', 'size:3'],
            'decline_reason' => ['sometimes', 'nullable', 'string', 'max:500'],
            'status' => ['sometimes', 'string', 'in:' . implode(',', [
                Listing::STATUS_DRAFT,
                Listing::STATUS_PUBLISHED,
                Listing::STATUS_REVIEW,
            ])],

            'quantity' => ['sometimes', 'integer', 'min:0'],
            'sku' => ['sometimes', 'nullable', 'string', 'max:100'],
            'barcode' => ['sometimes', 'nullable', 'string', 'max:100'],
            'allow_pos' => ['sometimes', 'boolean'],

            'location_country_code' => ['sometimes', 'nullable', 'string', 'size:2'],
            'location_city' => ['sometimes', 'nullable', 'string', 'max:120'],
            'location_district' => ['sometimes', 'nullable', 'string', 'max:120'],
            'latitude' => ['sometimes', 'nullable', 'numeric'],
            'longitude' => ['sometimes', 'nullable', 'numeric'],

            'attributes' => ['sometimes', 'nullable', 'array'],
            'custom_fields' => ['sometimes', 'nullable', 'array'],

            'meta_title' => ['sometimes', 'nullable', 'string', 'max:255'],
            'meta_description' => ['sometimes', 'nullable', 'string', 'max:500'],
            'meta_keywords' => ['sometimes', 'nullable', 'string', 'max:500'],
            'canonical_url' => ['sometimes', 'nullable', 'url', 'max:500'],

            'expires_at' => ['sometimes', 'nullable', 'date'],

            'tags' => ['sometimes', 'array', 'max:20'],
            'tags.*' => ['string', 'max:50'],

            'media_ids' => ['sometimes', 'array', 'max:10'],
            'media_ids.*' => ['integer', 'exists:listing_media,id'],
            'media' => ['sometimes', 'array', 'max:10'],
            'media.*' => ['file', 'mimetypes:image/jpeg,image/png,image/webp,image/gif,video/mp4,video/quicktime', 'max:10240'],
            'primary_media_index' => ['sometimes', 'nullable', 'integer', 'min:0'],
        ];
    }
}
