<?php

namespace App\Http\Requests\Business;

use App\Models\BusinessMembership;
use Illuminate\Foundation\Http\FormRequest;

class UpdateBusinessMemberRoleRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'role' => ['required', 'string', 'in:' . implode(',', [
                BusinessMembership::ROLE_MANAGER,
                BusinessMembership::ROLE_LISTINGS_MANAGER,
                BusinessMembership::ROLE_ANALYST,
            ])],
        ];
    }
}
