<?php

namespace App\Http\Requests\Business;

use App\Models\BusinessFeedback;
use Illuminate\Foundation\Http\FormRequest;

class StoreBusinessFeedbackRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'message' => ['required', 'string', 'max:5000'],
            'sentiment' => ['sometimes', 'string', 'in:' . implode(',', [
                BusinessFeedback::SENTIMENT_NEGATIVE,
                BusinessFeedback::SENTIMENT_NEUTRAL,
                BusinessFeedback::SENTIMENT_POSITIVE,
            ])],
            'attachments' => ['sometimes', 'array', 'max:6'],
            'attachments.*' => ['image', 'mimes:jpeg,jpg,png,gif,webp', 'max:5120'],
        ];
    }
}
