<?php

namespace App\Http\Requests\Business;

use App\Models\BusinessMembership;
use Illuminate\Foundation\Http\FormRequest;

class InviteBusinessMemberRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'email' => ['required', 'email:rfc,dns', 'max:255', 'exists:users,email'],
            'role' => ['required', 'string', 'in:' . implode(',', [
                BusinessMembership::ROLE_MANAGER,
                BusinessMembership::ROLE_LISTINGS_MANAGER,
                BusinessMembership::ROLE_ANALYST,
            ])],
        ];
    }
}
