<?php

namespace App\Http\Requests\Auth;

use App\Models\OtpVerification;
use Illuminate\Foundation\Http\FormRequest;

class VerifyOtpRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'identifier' => ['required', 'string', 'max:255'],
            'type' => ['required', 'string', 'in:' . implode(',', [
                OtpVerification::TYPE_EMAIL,
                OtpVerification::TYPE_PHONE,
                OtpVerification::TYPE_PHONE_PRIMARY,
                OtpVerification::TYPE_PHONE_SECONDARY,
                OtpVerification::TYPE_WHATSAPP,
                OtpVerification::TYPE_WHATSAPP_PRIMARY,
                OtpVerification::TYPE_WHATSAPP_SECONDARY,
            ])],
            'otp' => ['required', 'string', 'size:6', 'regex:/^\d{6}$/'],
        ];
    }

    public function messages(): array
    {
        return [
            'otp.size' => 'The OTP must be exactly 6 digits.',
            'otp.regex' => 'The OTP must contain only digits.',
        ];
    }
}
