<?php

namespace App\Http\Requests\Admin;

use App\Models\User;
use Illuminate\Foundation\Http\FormRequest;

class UpdateUserStatusRequest extends FormRequest
{
    public function authorize(): bool
    {
        return $this->user()->isAdmin();
    }

    public function rules(): array
    {
        return [
            'status' => [
                'required',
                'string',
                'in:' . implode(',', [User::STATUS_ACTIVE, User::STATUS_SUSPENDED]),
            ],
            'reason' => ['required_if:status,' . User::STATUS_SUSPENDED, 'nullable', 'string', 'max:500'],
        ];
    }

    public function messages(): array
    {
        return [
            'reason.required_if' => 'A reason is required when suspending a user.',
        ];
    }
}
