<?php

namespace App\Http\Requests\Admin;

use App\Models\User;
use Illuminate\Foundation\Http\FormRequest;

class ListUsersRequest extends FormRequest
{
    public function authorize(): bool
    {
        return $this->user()->isAdmin();
    }

    public function rules(): array
    {
        return [
            'search' => ['sometimes', 'nullable', 'string', 'max:255'],
            'status' => ['sometimes', 'nullable', 'string', 'in:' . implode(',', [User::STATUS_ACTIVE, User::STATUS_SUSPENDED, User::STATUS_DELETED])],
            'role' => ['sometimes', 'nullable', 'string', 'in:' . implode(',', [User::ROLE_USER, User::ROLE_SELLER, User::ROLE_ADMIN])],
            'sort_by' => ['sometimes', 'nullable', 'string', 'in:created_at,full_name,email,status,role'],
            'sort_order' => ['sometimes', 'nullable', 'string', 'in:asc,desc'],
            'per_page' => ['sometimes', 'nullable', 'integer', 'min:1', 'max:100'],
            'include_deleted' => ['sometimes', 'nullable', 'boolean'],
        ];
    }
}
