<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class SecurityHeaders
{
    /**
     * Security headers for API responses.
     */
    private array $headers = [
        'X-Content-Type-Options' => 'nosniff',
        'X-Frame-Options' => 'DENY',
        'X-XSS-Protection' => '1; mode=block',
        'Strict-Transport-Security' => 'max-age=31536000; includeSubDomains',
        'Content-Security-Policy' => "default-src 'none'; frame-ancestors 'none'",
        'Referrer-Policy' => 'strict-origin-when-cross-origin',
        'Permissions-Policy' => 'geolocation=(), microphone=(), camera=()',
        'Cache-Control' => 'no-store, no-cache, must-revalidate, proxy-revalidate',
        'Pragma' => 'no-cache',
    ];

    /**
     * Handle an incoming request.
     */
    public function handle(Request $request, Closure $next): Response
    {
        $response = $next($request);

        $isVerificationPage = $request->is('api/v1/auth/verify-email*');

        foreach ($this->headers as $key => $value) {
            if ($isVerificationPage && $key === 'Content-Security-Policy') {
                continue;
            }

            $response->headers->set($key, $value);
        }

        // Verification pages are HTML pages and rely on inline CSS.
        // Keep API responses strict, but allow minimal sources for these pages.
        if ($isVerificationPage) {
            $response->headers->set(
                'Content-Security-Policy',
                "default-src 'none'; style-src 'unsafe-inline'; img-src data:; frame-ancestors 'none'"
            );
        }

        return $response;
    }
}
