<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class OptionalAuth
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        if ($request->bearerToken()) {
            try {
                // Use the API guard to authenticate the token.
                // This doesn't throw if invalid, it just returns null or the user.
                Auth::guard('api')->user();
            } catch (\Throwable $e) {
                // Ignore any authentication errors to proceed as guest
            }
        }

        return $next($request);
    }
}
