<?php

namespace App\Http\Middleware;

use App\Http\Resources\ApiResponse;
use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class EnsureEmailIsVerified
{
    /**
     * Handle an incoming request.
     */
    public function handle(Request $request, Closure $next): Response
    {
        $user = auth('api')->user();

        if (!$user) {
            return ApiResponse::unauthorized('Authentication required.');
        }

        if (!$user->hasVerifiedEmail()) {
            return ApiResponse::forbidden('Your email address is not verified.');
        }

        return $next($request);
    }
}
