<?php

namespace App\Http\Controllers\Web;

use App\Http\Controllers\Controller;
use App\Models\Listing;
use App\Models\Business;
use App\Models\BlogPost;
use Illuminate\Http\Response;

class SitemapController extends Controller
{
    /**
     * Generate a dynamic XML sitemap.
     */
    public function index(): Response
    {
        $listings = Listing::where('status', 'published')
            ->orderBy('updated_at', 'desc')
            ->limit(5000)
            ->get();

        $businesses = Business::orderBy('updated_at', 'desc')
            ->limit(1000)
            ->get();

        $blogPosts = BlogPost::where('is_published', true)
            ->orderBy('published_at', 'desc')
            ->get();

        // Fetch categories for hub indexing
        $categories = [];
        $subcategories = [];
        $categoriesPath = public_path('assets/top_level_categories.json');
        if (file_exists($categoriesPath)) {
            $categories = json_decode(file_get_contents($categoriesPath), true);
        }

        $allSubcategoriesPath = public_path('assets/categories.json');
        if (file_exists($allSubcategoriesPath)) {
            $allSub = json_decode(file_get_contents($allSubcategoriesPath), true);
            // Only include subcategories that have a parent
            $subcategories = collect($allSub)->where('parent', '!=', '0')->all();
        }

        return response()->view('web.sitemap', [
            'listings' => $listings,
            'businesses' => $businesses,
            'blogPosts' => $blogPosts,
            'categories' => $categories,
            'subcategories' => $subcategories,
        ])->header('Content-Type', 'text/xml');
    }
}
