<?php

namespace App\Http\Controllers\Api\V1;

use App\Http\Controllers\Controller;
use App\Http\Resources\ApiResponse;
use App\Models\PremiumPackage;
use Illuminate\Http\JsonResponse;

class PremiumPackageController extends Controller
{
    public function index(): JsonResponse
    {
        $packages = PremiumPackage::where('is_active', true)
            ->orderBy('sort_order')
            ->orderBy('price')
            ->get();

        return ApiResponse::success([
            'packages' => $packages,
        ]);
    }

    public function show(string $slug): JsonResponse
    {
        $package = PremiumPackage::where('slug', $slug)
            ->where('is_active', true)
            ->first();

        if (!$package) {
            return ApiResponse::error('Package not found', 404);
        }

        return ApiResponse::success([
            'package' => $package,
        ]);
    }
}
