<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\Business;
use App\Models\Listing;
use Illuminate\Http\Request;
use Illuminate\View\View;

class DashboardController extends Controller
{
    /**
     * Display the admin dashboard home.
     */
    public function index(): View
    {
        $stats = [
            'total_users' => User::count(),
            'active_users' => User::where('status', User::STATUS_ACTIVE)->count(),
            'total_businesses' => Business::count(),
            'verified_businesses' => Business::where('verification_status', Business::VERIFICATION_VERIFIED)->count(),
            'pending_verifications' => Business::where('verification_status', Business::VERIFICATION_PENDING)->count(),
            'total_listings' => Listing::count(),
            'active_listings' => Listing::where('status', Listing::STATUS_PUBLISHED)->count(),
            'review_listings' => Listing::where('status', Listing::STATUS_REVIEW)->count(),
        ];

        // Recent Activity
        $recentUsers = User::latest()->take(5)->get();
        $recentListings = Listing::with(['business'])->latest()->take(5)->get();
        
        $pendingListings = Listing::where('status', Listing::STATUS_REVIEW)
            ->with(['createdBy', 'business'])
            ->latest()
            ->take(5)
            ->get();

        $pendingBusinesses = Business::where('verification_status', Business::VERIFICATION_PENDING)
            ->with(['owner'])
            ->latest()
            ->take(5)
            ->get();

        return view('admin.dashboard', compact('stats', 'recentUsers', 'recentListings', 'pendingBusinesses', 'pendingListings'));
    }
}
