# API Quick Reference Guide

**Base URL:** `http://your-domain/api/v1`

---

## 🔐 Authentication Endpoints

| Method | Endpoint | Auth | Description |
|--------|----------|------|-------------|
| POST | `/auth/register` | No | Register new user |
| POST | `/auth/login` | No | Login user |
| POST | `/auth/refresh` | No | Refresh access token |
| GET | `/auth/me` | Yes | Get current user |
| POST | `/auth/logout` | Yes | Logout current device |
| POST | `/auth/logout-all` | Yes | Logout all devices |
| POST | `/auth/forgot-password` | No | Request password reset |
| POST | `/auth/reset-password` | No | Reset password |
| POST | `/auth/send-otp` | No | Send OTP code |
| POST | `/auth/verify-otp` | No | Verify OTP code |

---

## 👤 User Management

| Method | Endpoint | Auth | Description |
|--------|----------|------|-------------|
| GET | `/user/profile` | Yes | Get user profile |
| PUT | `/user/profile` | Yes | Update profile |
| PUT | `/user/change-password` | Yes | Change password |
| DELETE | `/user/profile-photo` | Yes | Remove profile photo |
| DELETE | `/user/account` | Yes | Delete account |

---

## 🏢 Business Management

| Method | Endpoint | Auth | Description |
|--------|----------|------|-------------|
| GET | `/businesses` | Yes | List my businesses |
| POST | `/businesses` | Yes | Create business |
| GET | `/businesses/{id}` | Yes | Get business (private) |
| GET | `/businesses/{slug}` | No | Get business (public) |
| PUT | `/businesses/{id}` | Yes | Update business |
| DELETE | `/businesses/{id}` | Yes | Delete business |
| POST | `/businesses/{id}/follow` | Yes | Follow business |
| DELETE | `/businesses/{id}/follow` | Yes | Unfollow business |
| GET | `/businesses/{id}/members` | Yes | List members |
| POST | `/businesses/{id}/invites` | Yes | Invite member |
| PUT | `/businesses/{id}/members/{userId}/role` | Yes | Update member role |
| DELETE | `/businesses/{id}/members/{userId}` | Yes | Remove member |
| POST | `/businesses/{id}/transfer-ownership` | Yes | Transfer ownership |
| POST | `/businesses/{id}/verification/request` | Yes | Request verification |

---

## 📦 Listings

| Method | Endpoint | Auth | Description |
|--------|----------|------|-------------|
| GET | `/listings` | No | Browse all listings |
| GET | `/listings/{slug}` | No | Get listing (auto-tracks view) |
| POST | `/businesses/{id}/listings` | Yes | Create listing |
| GET | `/businesses/{id}/listings` | Yes | List business listings |
| GET | `/businesses/{id}/listings/{listingId}` | Yes | Get listing |
| PUT | `/businesses/{id}/listings/{listingId}` | Yes | Update listing |
| DELETE | `/businesses/{id}/listings/{listingId}` | Yes | Delete listing |
| POST | `/businesses/{id}/listings/{listingId}/bump` | Yes | Bump listing |
| POST | `/businesses/{id}/listings/media/upload` | Yes | Pre-upload media |
| POST | `/listings/generate-content` | Yes | AI generate content |
| POST | `/listings/search-by-image` | No | Reverse image search |

---

## 📊 Analytics & Tracking

| Method | Endpoint | Auth | Description |
|--------|----------|------|-------------|
| POST | `/analytics/impressions` | No | Track impression |
| POST | `/analytics/clicks` | No | Track click |
| POST | `/analytics/interactions` | No | Track interaction |
| GET | `/analytics/platform` | No | Platform analytics |
| GET | `/businesses/{id}/listings/{listingId}/analytics` | Yes | Listing analytics |
| GET | `/businesses/{id}/listings/{listingId}/views/stats` | Yes | View statistics |
| GET | `/businesses/{id}/listings/{listingId}/views/viewers` | Yes | List viewers |

---

## ⭐ Feedback

| Method | Endpoint | Auth | Description |
|--------|----------|------|-------------|
| POST | `/businesses/{id}/feedback` | Yes | Submit feedback |
| GET | `/businesses/{slug}/feedback` | No | Get business feedback |
| PUT | `/businesses/{id}/feedback/{feedbackId}` | Yes | Update feedback |
| DELETE | `/businesses/{id}/feedback/{feedbackId}` | Yes | Delete feedback |
| GET | `/businesses/{id}/feedback` | Yes | List feedback (owner) |
| POST | `/businesses/{id}/feedback/{feedbackId}/responses` | Yes | Respond to feedback |

---

## 🛡️ Admin (Admin Role Required)

| Method | Endpoint | Auth | Description |
|--------|----------|------|-------------|
| GET | `/admin/users` | Admin | List users |
| GET | `/admin/users/statistics` | Admin | User statistics |
| GET | `/admin/users/{id}` | Admin | Get user |
| PUT | `/admin/users/{id}/status` | Admin | Update user status |
| PUT | `/admin/users/{id}/role` | Admin | Update user role |
| POST | `/admin/users/{id}/restore` | Admin | Restore user |
| DELETE | `/admin/users/{id}/force` | Admin | Force delete user |
| GET | `/admin/business-feedback/pending` | Admin | Pending feedback |
| POST | `/admin/business-feedback/{id}/approve` | Admin | Approve feedback |
| POST | `/admin/business-feedback/{id}/reject` | Admin | Reject feedback |

---

## 🔑 Common Request Headers

```
Authorization: Bearer {access_token}
Content-Type: application/json
Accept: application/json
```

For file uploads:
```
Authorization: Bearer {access_token}
Content-Type: multipart/form-data
```

---

## 📝 Common Query Parameters

**Pagination:**
- `per_page` - Items per page (1-100, default: 20)
- `page` - Page number (default: 1)

**Listing Filters:**
- `search` - Search term
- `category` - Filter by category
- `sub_category` - Filter by sub-category
- `min_price` - Minimum price
- `max_price` - Maximum price
- `location_city` - Filter by city
- `location_district` - Filter by district
- `sort` - Sort order (price_asc, price_desc, newest, oldest, bumped)

**Analytics:**
- `period` - Time period (7days, 30days, 90days, year)
- `category` - Filter by category

---

## 🎯 Quick Examples

### Register & Login
```bash
# Register
curl -X POST http://localhost/api/v1/auth/register \
  -H "Content-Type: application/json" \
  -d '{
    "first_name": "John",
    "last_name": "Doe",
    "email": "john@example.com",
    "phone_number": "+256700123456",
    "password": "SecurePass123!",
    "password_confirmation": "SecurePass123!"
  }'

# Login
curl -X POST http://localhost/api/v1/auth/login \
  -H "Content-Type: application/json" \
  -d '{
    "email": "john@example.com",
    "password": "SecurePass123!"
  }'
```

### Create Business
```bash
curl -X POST http://localhost/api/v1/businesses \
  -H "Authorization: Bearer YOUR_TOKEN" \
  -F "name=John's Electronics" \
  -F "description=Best electronics in town" \
  -F "category=Electronics" \
  -F "phone_number=+256700123456" \
  -F "logo=@/path/to/logo.jpg"
```

### Create Listing
```bash
curl -X POST http://localhost/api/v1/businesses/1/listings \
  -H "Authorization: Bearer YOUR_TOKEN" \
  -F "title=Red Evening Dress" \
  -F "description=Beautiful red dress..." \
  -F "price_amount=25000" \
  -F "category=Fashion" \
  -F "status=published" \
  -F "media[]=@/path/to/image1.jpg" \
  -F "media[]=@/path/to/image2.jpg"
```

### Browse Listings
```bash
curl "http://localhost/api/v1/listings?category=Fashion&min_price=10000&max_price=50000&sort=newest&per_page=20"
```

### Track Impression (Frontend)
```javascript
fetch('/api/v1/analytics/impressions', {
  method: 'POST',
  headers: { 'Content-Type': 'application/json' },
  body: JSON.stringify({
    listing_id: 1,
    source: 'feed',
    context: { position: 3 }
  })
});
```

### Get Listing Analytics
```bash
curl -X GET "http://localhost/api/v1/businesses/1/listings/1/analytics?period=30days" \
  -H "Authorization: Bearer YOUR_TOKEN"
```

---

## ⚠️ Important Notes

1. **Authentication:** Most endpoints require JWT Bearer token
2. **Rate Limiting:** 
   - Auth endpoints: 5 req/min
   - General: 60 req/min
   - File uploads: 10 req/min
3. **File Uploads:** Use `multipart/form-data` content type
4. **Phone Numbers:** Must be in E.164 format (+256700123456)
5. **Dates:** ISO 8601 format (2025-12-21T06:00:00Z)
6. **View Tracking:** Automatic on listing detail page
7. **Impression/Click Tracking:** Manual from frontend
8. **Soft Deletes:** Deleted items can be restored by admins

---

## 🚨 Error Codes

- **400** - Bad Request
- **401** - Unauthorized (not logged in)
- **403** - Forbidden (no permission)
- **404** - Not Found
- **422** - Validation Error
- **429** - Too Many Requests
- **500** - Server Error

---

**Full Documentation:** See `API_DOCUMENTATION.md`
